/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps;

import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.Build;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.BuildList;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.JsonParser;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.RequestExecutor;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.AbstractBuildStep;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.BuildProcessor;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.BuildAbsoluteId;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.HttpBasedStep;
import org.squashtest.tm.service.testautomation.spi.NotFoundException;

public class GetBuildID
extends AbstractBuildStep<GetBuildID>
implements HttpBasedStep {
    private CloseableHttpClient client;
    private HttpUriRequest method;
    private JsonParser parser;
    private BuildAbsoluteId absoluteId;

    public GetBuildID(BuildProcessor processor) {
        super(processor);
    }

    @Override
    public void setClient(CloseableHttpClient client) {
        this.client = client;
    }

    @Override
    public void setMethod(HttpUriRequest method) {
        this.method = method;
    }

    @Override
    public void setParser(JsonParser parser) {
        this.parser = parser;
    }

    @Override
    public void setBuildAbsoluteId(BuildAbsoluteId absoluteId) {
        this.absoluteId = absoluteId;
    }

    public Integer getBuildID() {
        return this.absoluteId.getBuildId();
    }

    @Override
    public boolean needsRescheduling() {
        return this.absoluteId.getBuildId() == null;
    }

    @Override
    public void perform() throws Exception {
        String json = RequestExecutor.getInstance().execute(this.client, this.method);
        BuildList buildList = this.parser.getBuildListFromJson(json);
        Build buildOfInterest = buildList.findByExternalId(this.absoluteId.getExternalId());
        if (buildOfInterest == null) {
            throw new NotFoundException("TestAutomationConnector : the requested build for project " + this.absoluteId.toString() + " cannot be found");
        }
        int buildId = buildOfInterest.getId();
        this.absoluteId.setBuildId(buildId);
    }

    @Override
    public void reset() {
    }

    @Override
    public Integer suggestedReschedulingInterval() {
        return null;
    }
}

