/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.beans;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TestListElement {
    private String name;
    private MetadataElement metadata;
    private Date timestamp;
    private TestListElement[] contents;

    private boolean amIPseudoRoot() {
        return this.timestamp != null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public TestListElement[] getContents() {
        return this.contents;
    }

    public void setContents(TestListElement[] contents) {
        this.contents = contents == null ? null : Arrays.copyOf(contents, contents.length);
    }

    public MetadataElement getMetadata() {
        return this.metadata;
    }

    public void setMetadata(MetadataElement metadata) {
        this.metadata = metadata;
    }

    public Map<String, List<String>> collectAllTestNamesWithLinkedTestCases() {
        LinkedHashMap<String, List<String>> testNamesWithLinkedTCMap = new LinkedHashMap<String, List<String>>();
        if (this.contents != null) {
            String thisName = !this.amIPseudoRoot() ? String.valueOf(this.name) + "/" : "";
            TestListElement[] testListElementArray = this.contents;
            int n = this.contents.length;
            int n2 = 0;
            while (n2 < n) {
                TestListElement content = testListElementArray[n2];
                Map<String, List<String>> subMap = content.collectAllTestNamesWithLinkedTestCases();
                subMap.forEach((testName, linkedTestCaseList) -> {
                    List list = testNamesWithLinkedTCMap.put(String.valueOf(thisName) + testName, (List<String>)linkedTestCaseList);
                });
                ++n2;
            }
        } else if (this.metadata == null || this.metadata.getLinkedTC() == null) {
            testNamesWithLinkedTCMap.put(this.name, Collections.emptyList());
        } else {
            testNamesWithLinkedTCMap.put(this.name, this.metadata.getLinkedTC());
        }
        return testNamesWithLinkedTCMap;
    }

    private class MetadataElement {
        @JsonProperty(value="linked-TC")
        private List<String> linkedTC;

        public List<String> getLinkedTC() {
            return this.linkedTC;
        }
    }
}

