/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps;

import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.Item;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.ItemList;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.JsonParser;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.RequestExecutor;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.BuildProcessor;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.BuildStep;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.BuildAbsoluteId;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.HttpBasedStep;

public class CheckBuildQueue
extends BuildStep<CheckBuildQueue>
implements HttpBasedStep {
    private RequestExecutor requestExecutor = RequestExecutor.getInstance();
    private CloseableHttpClient client;
    private HttpUriRequest method;
    private JsonParser parser;
    private BuildAbsoluteId absoluteId;
    private boolean buildIsQueued = true;

    public CheckBuildQueue(BuildProcessor processor) {
        super(processor);
    }

    @Override
    public void setClient(CloseableHttpClient client) {
        this.client = client;
    }

    @Override
    public void setMethod(HttpUriRequest method) {
        this.method = method;
    }

    @Override
    public void setParser(JsonParser parser) {
        this.parser = parser;
    }

    @Override
    public void setBuildAbsoluteId(BuildAbsoluteId absoluteId) {
        this.absoluteId = absoluteId;
    }

    @Override
    public boolean needsRescheduling() {
        return this.buildIsQueued;
    }

    @Override
    public void perform() throws Exception {
        String result = this.requestExecutor.execute(this.client, this.method);
        ItemList queuedBuilds = this.parser.getQueuedListFromJson(result);
        Item buildOfInterest = queuedBuilds.findQueuedBuildByExtId(this.absoluteId.getProjectName(), this.absoluteId.getExternalId());
        this.buildIsQueued = buildOfInterest != null;
    }

    @Override
    public void reset() {
        this.buildIsQueued = true;
    }

    @Override
    public Integer suggestedReschedulingInterval() {
        return null;
    }
}

