/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal.net;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.service.testautomation.spi.TestAutomationException;

@Component
public class HttpClientProvider {
    private CredentialsProvider credentialsProvider = new BasicCredentialsProvider();
    private final CloseableHttpClient client;
    private final ClientHttpRequestFactory requestFactory;

    public HttpClientProvider() {
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager();
        manager.setMaxTotal(25);
        this.client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)manager).addInterceptorFirst((HttpRequestInterceptor)new PreemptiveAuthInterceptor()).setDefaultCredentialsProvider(this.credentialsProvider).build();
        this.requestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)this.client);
    }

    public CloseableHttpClient getClientFor(TestAutomationServer server, String login, String password) {
        URL baseURL = null;
        try {
            baseURL = new URL(server.getUrl());
            this.credentialsProvider.setCredentials(new AuthScope(baseURL.getHost(), baseURL.getPort(), AuthScope.ANY_REALM), (Credentials)new UsernamePasswordCredentials(login, password));
        }
        catch (MalformedURLException e) {
            throw new TestAutomationException((Throwable)e);
        }
        return this.client;
    }

    public ClientHttpRequestFactory getRequestFactoryFor(TestAutomationServer server, String login, String password) throws TestAutomationException {
        this.getClientFor(server, login, password);
        return this.requestFactory;
    }

    static class PreemptiveAuthInterceptor
    implements HttpRequestInterceptor {
        PreemptiveAuthInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState.getAuthScheme() == null) {
                HttpHost targetHost;
                BasicScheme authScheme = new BasicScheme();
                CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                Credentials creds = credsProvider.getCredentials(new AuthScope((targetHost = (HttpHost)context.getAttribute("http.target_host")).getHostName(), targetHost.getPort()));
                if (creds == null) {
                    throw new HttpException("No credentials for preemptive authentication");
                }
                authState.setAuthScheme((AuthScheme)authScheme);
                authState.setCredentials(creds);
            }
        }
    }
}

