/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks;

import java.util.Collection;
import java.util.LinkedList;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.BuildProcessor;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.StepEventListener;

public abstract class AbstractBuildStep<S extends AbstractBuildStep<S>>
implements Runnable {
    protected BuildProcessor buildProcessor;
    private Collection<StepEventListener<S>> eventListeners;

    protected AbstractBuildStep(BuildProcessor processor) {
        this.buildProcessor = processor;
    }

    public void addListener(StepEventListener<S> newListener) {
        if (this.eventListeners == null) {
            this.eventListeners = new LinkedList<StepEventListener<S>>();
        }
        this.eventListeners.add(newListener);
    }

    public void setBuildProcessor(BuildProcessor processor) {
        this.buildProcessor = processor;
    }

    @Override
    public void run() {
        try {
            this.perform();
            this.notifyListenerComplete();
            this.buildProcessor.notifyStepDone();
        }
        catch (Exception ex) {
            this.notifyListenerError(ex);
            this.buildProcessor.notifyException(ex);
        }
    }

    private void notifyListenerComplete() {
        if (this.eventListeners != null) {
            for (StepEventListener<AbstractBuildStep> stepEventListener : this.eventListeners) {
                stepEventListener.onComplete(this);
            }
        }
    }

    private void notifyListenerError(Exception ex) {
        if (this.eventListeners != null) {
            for (StepEventListener<AbstractBuildStep> stepEventListener : this.eventListeners) {
                stepEventListener.onError(this, ex);
            }
        }
    }

    public abstract boolean needsRescheduling();

    public abstract void perform() throws Exception;

    public abstract void reset();

    public abstract Integer suggestedReschedulingInterval();
}

