/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal;

import java.util.NoSuchElementException;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.AbstractHttpBasedStepSequence;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.BuildStage;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.AbstractBuildProcessor;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.AbstractBuildStep;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.StepSequence;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.BuildAbsoluteId;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.StartBuild;

class FetchTestListStepSequence
extends AbstractHttpBasedStepSequence
implements StepSequence {
    private final AbstractBuildProcessor processor;

    FetchTestListStepSequence(AbstractBuildProcessor processor) {
        this.processor = processor;
    }

    @Override
    void setClient(CloseableHttpClient client) {
        this.client = client;
    }

    @Override
    void setProject(TestAutomationProject project) {
        this.project = project;
    }

    @Override
    void setAbsoluteId(BuildAbsoluteId absoluteId) {
        this.absoluteId = absoluteId;
    }

    @Override
    protected AbstractBuildProcessor getProcessor() {
        return this.processor;
    }

    @Override
    public boolean hasNext() {
        return this.currentStage != BuildStage.GATHER_RESULT;
    }

    @Override
    public AbstractBuildStep<?> next() {
        return switch (this.currentStage) {
            case BuildStage.WAITING -> {
                this.currentStage = BuildStage.START_BUILD;
                yield this.newStartBuild();
            }
            case BuildStage.START_BUILD -> {
                this.currentStage = BuildStage.CHECK_QUEUE;
                yield this.newCheckQueue();
            }
            case BuildStage.CHECK_QUEUE -> {
                this.currentStage = BuildStage.GET_BUILD_ID;
                yield this.newGetBuildID();
            }
            case BuildStage.GET_BUILD_ID -> {
                this.currentStage = BuildStage.CHECK_BUILD_RUNNING;
                yield this.newCheckBuildRunning();
            }
            case BuildStage.CHECK_BUILD_RUNNING -> {
                this.currentStage = BuildStage.GATHER_RESULT;
                yield this.newGatherTestList();
            }
            default -> throw new NoSuchElementException();
        };
    }

    protected StartBuild newStartBuild() {
        HttpPost method = this.requestFactory.newStartFetchTestListBuild(this.project, this.absoluteId.getExternalId());
        StartBuild startBuild = new StartBuild(this.getProcessor());
        this.wireHttpSteps(startBuild, (HttpUriRequest)method);
        return startBuild;
    }
}

