/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks;

import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.AbstractBuildStep;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.BuildProcessor;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.SameThreadStepScheduler;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.StepFuture;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.StepScheduler;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.StepSequence;

public abstract class AbstractBuildProcessor
implements BuildProcessor {
    protected StepScheduler scheduler = new SameThreadStepScheduler();
    private int defaultReschedulingInterval = 3000;
    protected AbstractBuildStep<?> currentStep = null;
    protected StepFuture currentFuture = null;
    private boolean canceled;

    public StepScheduler getScheduler() {
        return this.scheduler;
    }

    public void setDefaultReschedulingDelay(int defaultReschedulingDelay) {
        this.defaultReschedulingInterval = defaultReschedulingDelay;
    }

    protected AbstractBuildStep<?> getCurrentStep() {
        return this.currentStep;
    }

    protected StepFuture getCurrentFuture() {
        return this.currentFuture;
    }

    public int getDefaultReschedulingDelay() {
        return this.defaultReschedulingInterval;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void cancel() {
        this.currentFuture.cancel();
        this.canceled = true;
    }

    public boolean taskHasBegun() {
        return this.currentStep != null;
    }

    protected void scheduleNextStep() {
        if (!this.taskHasBegun()) {
            this.currentStep = (AbstractBuildStep)this.getStepSequence().next();
            this.scheduler.schedule(this.currentStep);
        } else if (this.currentStep.needsRescheduling()) {
            this.reschedule();
        } else {
            this.currentStep = (AbstractBuildStep)this.getStepSequence().next();
            this.scheduler.schedule(this.currentStep);
        }
    }

    protected void reschedule() {
        int delay = this.currentStep.suggestedReschedulingInterval() != null ? this.currentStep.suggestedReschedulingInterval() : this.defaultReschedulingInterval;
        this.currentFuture = this.scheduler.schedule(this.currentStep, delay);
    }

    protected abstract StepSequence getStepSequence();
}

