/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.validation.constraints.NotNull;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hc.core5.net.URIBuilder;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;
import org.squashtest.tm.core.foundation.lang.Couple;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.plugin.testautomation.jenkins.TestAutomationJenkinsConnector;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.JenkinsCrumb;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.ParameterArray;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.BuildDef;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.HttpClientProvider;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.HttpRequestFactory;
import org.squashtest.tm.service.testautomation.spi.AccessDenied;
import org.squashtest.tm.service.testautomation.spi.NotFoundException;
import org.squashtest.tm.service.testautomation.spi.ServerConnectionFailed;
import org.squashtest.tm.service.testautomation.spi.TestAutomationException;

public class StartTestExecution {
    public static final String AUTHORIZATION = "Authorization";
    private static final Logger LOGGER = LoggerFactory.getLogger(StartTestExecution.class);
    private static final String UNUSED = "unused";
    public static final String BASIC = "Basic ";
    private final BuildDef buildDef;
    private final String externalId;
    private final RestTemplate template;
    private HttpRequestFactory httpRequestFactory;

    public StartTestExecution(BuildDef buildDef, HttpClientProvider clientProvider, HttpRequestFactory httpRequestFactory, String externalId) {
        this.buildDef = buildDef;
        this.httpRequestFactory = httpRequestFactory;
        this.externalId = externalId;
        this.template = clientProvider.getRestTemplateFor(buildDef.getProject().getServer(), buildDef.getCredentials().getUsername(), String.valueOf(buildDef.getCredentials().getPassword()));
    }

    public void run() {
        TestAutomationProject project = this.buildDef.getProject();
        JenkinsCrumb crumb = this.getCrumb(project.getServer());
        URI url = this.createUrl(project);
        MultiValueMap<String, ?> postData = this.createPostData(this.buildDef, this.externalId);
        ResponseEntity<Void> response = this.execute(url, crumb, postData);
        LOGGER.info("started build with response status: {}", new Object[]{response.getStatusCode()});
    }

    private JenkinsCrumb getCrumb(TestAutomationServer server) {
        try {
            LOGGER.trace("fetching CSRF jenkins crumb", new Object[0]);
            URI uri = new URI(server.getUrl() + "/crumbIssuer/api/json");
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
            RequestEntity request = new RequestEntity((MultiValueMap)headers, HttpMethod.GET, uri);
            ResponseEntity response = this.template.exchange(request, JenkinsCrumb.class);
            LOGGER.trace("crumb found", new Object[0]);
            return (JenkinsCrumb)response.getBody();
        }
        catch (HttpClientErrorException e) {
            if (e.getStatusCode() == HttpStatus.NOT_FOUND) {
                LOGGER.trace("no crumb found, CSRF protection seems disabled", new Object[0]);
                return null;
            }
            LOGGER.error("Failed to get crumb: {} - {}", new Object[]{e.getStatusCode(), e.getResponseBodyAsString()});
            throw new ServerConnectionFailed((Throwable)e);
        }
        catch (URISyntaxException ex) {
            LOGGER.error("cannot fetch crumb from server '{}' due to URI syntax exception. Is the server URL correct ?", new Object[]{server.getUrl()});
            throw new RuntimeException(ex);
        }
    }

    private ResponseEntity<Void> execute(URI url, JenkinsCrumb crumb, MultiValueMap<String, ?> postData) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.MULTIPART_FORM_DATA);
            headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
            String authHeader = BASIC + Base64.getEncoder().encodeToString((this.buildDef.getCredentials().getUsername() + ":" + String.valueOf(this.buildDef.getCredentials().getPassword())).getBytes(StandardCharsets.UTF_8));
            headers.set(AUTHORIZATION, authHeader);
            if (crumb != null) {
                headers.add(crumb.getCrumbRequestField(), crumb.getCrumb());
                headers.add("Cookie", ".crumb=" + crumb.getCrumb());
            }
            RequestEntity request = new RequestEntity(postData, (MultiValueMap)headers, HttpMethod.POST, url);
            LOGGER.debug("Executing request to Jenkins: {} with headers: {}", new Object[]{url, headers});
            ResponseEntity response = this.template.exchange(request, Void.class);
            LOGGER.debug("Jenkins response status: {}", new Object[]{response.getStatusCode()});
            return response;
        }
        catch (ResourceAccessException ex) {
            throw new ServerConnectionFailed((Throwable)ex);
        }
        catch (HttpClientErrorException ex) {
            LOGGER.error("HTTP error: {} - {}", new Object[]{ex.getStatusCode(), ex.getResponseBodyAsString()});
            switch (ex.getStatusCode().value()) {
                case 401: 
                case 403: 
                case 407: {
                    LOGGER.error("Authentication failed. Check Jenkins credentials and permissions. Response: {}", new Object[]{ex.getResponseBodyAsString()});
                    throw new AccessDenied();
                }
                case 404: {
                    throw new NotFoundException((Throwable)ex);
                }
            }
            throw new TestAutomationException(ex.getMessage(), (Throwable)ex);
        }
        catch (HttpServerErrorException ex) {
            LOGGER.error("build fail due to Jenkins error:", new Object[0]);
            LOGGER.error("Message: {}", new Object[]{ex.getMessage()});
            LOGGER.error("Response: {}", new Object[]{ex.getResponseBodyAsString()});
            throw new TestAutomationException(ex.getMessage(), (Throwable)ex);
        }
    }

    private URI createUrl(TestAutomationProject project) {
        TestAutomationServer server = project.getServer();
        String jobSubPath = TestAutomationJenkinsConnector.getJobSubPath(project);
        try {
            URI base = new URI(server.getUrl());
            return new URIBuilder(base).setPath(base.getPath() + jobSubPath + "/build").build();
        }
        catch (URISyntaxException use) {
            LOGGER.error("cannot execute build for job {} hosted on server {}. Job Sub path is {}. due to URI syntax exception. Is the server URL correct ?", new Object[]{project.getJobName(), project.getServer().getUrl(), jobSubPath});
            throw new RuntimeException(use);
        }
    }

    private MultiValueMap<String, ?> createPostData(BuildDef buildDef, String externalId) {
        LinkedMultiValueMap parts = new LinkedMultiValueMap();
        ParameterArray stdParams = this.httpRequestFactory.getStartTestSuiteBuildParameters(externalId, buildDef.getNode());
        try {
            File tmp = this.createJsonSuite(buildDef);
            parts.add((Object)"file0", (Object)new FileSystemResource(tmp));
            parts.add((Object)"json", (Object)new ObjectMapper().writeValueAsString((Object)stdParams));
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Error while mashalling json model. Maybe a bug ?", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("Error while writing json model into temp file. Maybe temp folder is not writable ?", (Throwable)e);
        }
        return parts;
    }

    private File createJsonSuite(BuildDef buildDef) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        File tmp = File.createTempFile("ta-suite", ".json");
        tmp.deleteOnExit();
        objectMapper.writeValue(tmp, (Object)new JsonSuiteAdapter(buildDef));
        return tmp;
    }

    private static final class JsonSuiteAdapter {
        private final BuildDef buildDef;
        private List<JsonTestAdapter> tests;

        private JsonSuiteAdapter(BuildDef buildDef) {
            this.buildDef = buildDef;
        }

        public List<JsonTestAdapter> getTest() {
            if (this.tests == null) {
                this.tests = new ArrayList<JsonTestAdapter>();
                for (Couple<AutomatedExecutionExtender, Map<String, Object>> paramdExec : this.buildDef.getParameterizedExecutions()) {
                    JsonTestAdapter json = new JsonTestAdapter(paramdExec);
                    this.tests.add(json);
                }
            }
            return this.tests;
        }
    }

    private static final class JsonTestAdapter {
        private final Couple<AutomatedExecutionExtender, Map<String, Object>> paramdExec;

        private JsonTestAdapter(@NotNull Couple<AutomatedExecutionExtender, Map<String, Object>> paramdExec) {
            this.paramdExec = paramdExec;
        }

        public String getScript() {
            return ((AutomatedExecutionExtender)this.paramdExec.getA1()).getAutomatedTest().getName();
        }

        public String getId() {
            return ((AutomatedExecutionExtender)this.paramdExec.getA1()).getId().toString();
        }

        public Map<String, Object> getParam() {
            return (Map)this.paramdExec.getA2();
        }
    }
}

