/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps;

import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.Build;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.JsonParser;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.RequestExecutor;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.AbstractBuildStep;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.BuildProcessor;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.BuildAbsoluteId;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.HttpBasedStep;

public class CheckBuildRunning
extends AbstractBuildStep<CheckBuildRunning>
implements HttpBasedStep {
    private CloseableHttpClient client;
    private HttpUriRequest method;
    private JsonParser parser;
    private boolean stillBuilding = true;

    public CheckBuildRunning(BuildProcessor processor) {
        super(processor);
    }

    @Override
    public void setClient(CloseableHttpClient client) {
        this.client = client;
    }

    @Override
    public void setMethod(HttpUriRequest method) {
        this.method = method;
    }

    @Override
    public void setParser(JsonParser parser) {
        this.parser = parser;
    }

    @Override
    public void setBuildAbsoluteId(BuildAbsoluteId absoluteId) {
    }

    @Override
    public boolean needsRescheduling() {
        return this.stillBuilding;
    }

    @Override
    public void perform() throws Exception {
        String response = RequestExecutor.getInstance().execute(this.client, this.method);
        Build build = this.parser.getBuildFromJson(response);
        this.stillBuilding = build.isBuilding();
    }

    @Override
    public void reset() {
        this.stillBuilding = true;
    }

    @Override
    public Integer suggestedReschedulingInterval() {
        return null;
    }
}

