/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal.net;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.service.testautomation.spi.TestAutomationException;

@Component
public class HttpClientProvider {
    private final BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
    private final CloseableHttpClient client;
    private final ClientHttpRequestFactory requestFactory;

    public HttpClientProvider() {
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager();
        manager.setMaxTotal(25);
        this.client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)manager).addRequestInterceptorFirst((HttpRequestInterceptor)new PreemptiveAuthInterceptor()).setDefaultCredentialsProvider((CredentialsProvider)this.credentialsProvider).build();
        this.requestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)this.client);
    }

    public CloseableHttpClient getClientFor(TestAutomationServer server, String login, String password) {
        try {
            URL baseURL = new URL(server.getUrl());
            this.credentialsProvider.setCredentials(new AuthScope(baseURL.getHost(), baseURL.getPort()), (Credentials)new UsernamePasswordCredentials(login, password.toCharArray()));
        }
        catch (MalformedURLException e) {
            throw new TestAutomationException((Throwable)e);
        }
        return this.client;
    }

    public ClientHttpRequestFactory getRequestFactoryFor(TestAutomationServer server, String login, String password) throws TestAutomationException {
        this.getClientFor(server, login, password);
        return this.requestFactory;
    }

    static class PreemptiveAuthInterceptor
    implements HttpRequestInterceptor {
        PreemptiveAuthInterceptor() {
        }

        public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
            AuthCache authCache = (AuthCache)context.getAttribute("http.auth.auth-cache");
            if (authCache == null) {
                HttpRoute targetRoute;
                HttpHost targetHost;
                BasicScheme authScheme = new BasicScheme();
                CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                Credentials creds = credsProvider.getCredentials(new AuthScope((targetHost = (targetRoute = (HttpRoute)context.getAttribute("http.route")).getTargetHost()).getHostName(), targetHost.getPort()), context);
                if (creds == null) {
                    throw new HttpException("No credentials for preemptive authentication");
                }
                authCache = new BasicAuthCache();
                authCache.put(targetHost, (AuthScheme)authScheme);
                context.setAttribute("http.auth.auth-cache", (Object)authCache);
                context.setAttribute("http.auth.credentials-provider", (Object)credsProvider);
            }
        }
    }
}

