/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.squashtest.tm.domain.servers.BasicAuthenticationCredentials;
import org.squashtest.tm.domain.testautomation.AutomatedTest;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.TestListElement;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.JsonParser;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.HttpClientProvider;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.HttpRequestFactory;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.RequestExecutor;

public class OptimisticTestList {
    private HttpClientProvider clientProvider;
    private TestAutomationProject project;
    private JsonParser parser = new JsonParser();
    private BasicAuthenticationCredentials basicAuthenticationCredentials;

    public OptimisticTestList(HttpClientProvider clientProvider, TestAutomationProject project, BasicAuthenticationCredentials basicAuthenticationCredentials) {
        this.clientProvider = clientProvider;
        this.project = project;
        this.basicAuthenticationCredentials = basicAuthenticationCredentials;
    }

    public Collection<AutomatedTest> run() throws IOException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (CloseableHttpClient client = this.getClient();){
                HttpGet method = new HttpRequestFactory().newGetJsonTestList(this.project);
                String response = RequestExecutor.getInstance().execute(client, (HttpUriRequest)method);
                TestListElement testList = this.parser.getTestListFromJson(response);
                LinkedList<AutomatedTest> tests = new LinkedList<AutomatedTest>();
                Map<String, List<String>> testNamesWithLinkTCMap = testList.collectAllTestNamesWithLinkedTestCases();
                testNamesWithLinkTCMap.forEach((testName, linkedTestCases) -> {
                    AutomatedTest test = new AutomatedTest(testName, this.project, linkedTestCases);
                    tests.add(test);
                });
                return tests;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IOException("Error while trying to fetch automated tests", e);
        }
    }

    private CloseableHttpClient getClient() {
        return this.clientProvider.getClientFor(this.project.getServer(), this.basicAuthenticationCredentials.getUsername(), String.valueOf(this.basicAuthenticationCredentials.getPassword()));
    }
}

