/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.Build;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.BuildList;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.JsonParser;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.RequestExecutor;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.BuildProcessor;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.BuildStep;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.BuildAbsoluteId;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.HttpBasedStep;
import org.squashtest.tm.service.testautomation.spi.NotFoundException;

public class GetBuildID
extends BuildStep<GetBuildID>
implements HttpBasedStep {
    private RequestExecutor requestExecutor = RequestExecutor.getInstance();
    private HttpClient client;
    private HttpMethod method;
    private JsonParser parser;
    private BuildAbsoluteId absoluteId;

    @Override
    public void setClient(HttpClient client) {
        this.client = client;
    }

    @Override
    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    @Override
    public void setParser(JsonParser parser) {
        this.parser = parser;
    }

    @Override
    public void setBuildAbsoluteId(BuildAbsoluteId absoluteId) {
        this.absoluteId = absoluteId;
    }

    public Integer getBuildID() {
        return this.absoluteId.getBuildId();
    }

    public GetBuildID(BuildProcessor processor) {
        super(processor);
    }

    @Override
    public boolean needsRescheduling() {
        return this.absoluteId.getBuildId() == null;
    }

    @Override
    public void perform() throws Exception {
        String json = this.requestExecutor.execute(this.client, this.method);
        BuildList buildList = this.parser.getBuildListFromJson(json);
        Build buildOfInterest = buildList.findByExternalId(this.absoluteId.getExternalId());
        if (buildOfInterest == null) {
            throw new NotFoundException("TestAutomationConnector : the requested build for project " + this.absoluteId.toString() + " cannot be found");
        }
        int buildId = buildOfInterest.getId();
        this.absoluteId.setBuildId(buildId);
    }

    @Override
    public void reset() {
    }

    @Override
    public Integer suggestedReschedulingInterval() {
        return null;
    }
}

