/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal;

import java.util.NoSuchElementException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.BuildStage;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.ExecuteAndWatchBuildProcessor;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.HttpBasedStepSequence;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.AbstractBuildProcessor;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.BuildStep;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.StepEventListener;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.StepSequence;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.GetBuildID;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.StartBuild;
import org.squashtest.tm.service.testautomation.model.TestAutomationProjectContent;

class ExecuteAndWatchStepSequence
extends HttpBasedStepSequence
implements StepSequence {
    private TestAutomationProjectContent projectContent;
    private ExecuteAndWatchBuildProcessor processor;
    private StepEventListener<GetBuildID> buildIDListener;

    public void setBuildIDEventListener(StepEventListener<GetBuildID> listener) {
        this.buildIDListener = listener;
    }

    void setProjectContent(TestAutomationProjectContent content) {
        this.projectContent = content;
        this.setProject(content.getProject());
    }

    @Override
    protected AbstractBuildProcessor getProcessor() {
        return this.processor;
    }

    ExecuteAndWatchStepSequence(ExecuteAndWatchBuildProcessor processor) {
        this.processor = processor;
    }

    @Override
    public boolean hasMoreElements() {
        return this.currentStage != BuildStage.GET_BUILD_ID;
    }

    @Override
    public BuildStep<?> nextElement() {
        switch (this.currentStage) {
            case WAITING: {
                this.currentStage = BuildStage.START_BUILD;
                return this.newStartBuild();
            }
            case START_BUILD: {
                this.currentStage = BuildStage.CHECK_QUEUE;
                return this.newCheckQueue();
            }
            case CHECK_QUEUE: {
                this.currentStage = BuildStage.GET_BUILD_ID;
                return this.newGetBuildID();
            }
            case GET_BUILD_ID: {
                throw new NoSuchElementException();
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    protected GetBuildID newGetBuildID() {
        GetBuildID step = super.newGetBuildID();
        step.addListener(this.buildIDListener);
        return step;
    }

    protected StartBuild newStartBuild() {
        PostMethod method = this.requestFactory.newStartTestSuiteBuild(this.projectContent, this.absoluteId.getExternalId());
        StartBuild startBuild = new StartBuild(this.processor);
        this.wireHttpSteps(startBuild, (HttpMethod)method);
        return startBuild;
    }
}

