/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.Build;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.BuildList;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.ItemList;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.Job;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.JobList;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.TestList;
import org.squashtest.tm.service.testautomation.spi.TestAutomationException;
import org.squashtest.tm.service.testautomation.spi.UnreadableResponseException;

public class JsonParser {
    private static final String DISABLED_COLOR_STRING = "disabled";
    private ObjectMapper objMapper = new ObjectMapper();

    public Collection<TestAutomationProject> readJobListFromJson(String json) {
        try {
            JobList list = (JobList)this.objMapper.readValue(json, JobList.class);
            JobList filteredList = this.filterDisabledJobs(list);
            Collection<TestAutomationProject> projectsList = this.toProjectList(filteredList);
            return projectsList;
        }
        catch (JsonParseException e) {
            throw new UnreadableResponseException((Throwable)e);
        }
        catch (JsonMappingException e) {
            throw new UnreadableResponseException((Throwable)e);
        }
        catch (IOException e) {
            throw new UnreadableResponseException((Throwable)e);
        }
    }

    public ItemList getQueuedListFromJson(String json) {
        return this.safeReadValue(json, ItemList.class);
    }

    public BuildList getBuildListFromJson(String json) {
        return this.safeReadValue(json, BuildList.class);
    }

    public TestList getTestListFromJson(String json) {
        return this.safeReadValue(json, TestList.class);
    }

    public Build getBuildFromJson(String json) {
        return this.safeReadValue(json, Build.class);
    }

    public String toJson(Object object) {
        try {
            return this.objMapper.writeValueAsString(object);
        }
        catch (JsonGenerationException e) {
            throw new TestAutomationException("TestAutomationConnector : internal error, could not generate json", (Throwable)e);
        }
        catch (JsonMappingException e) {
            throw new TestAutomationException("TestAutomationConnector : internal error, could not generate json", (Throwable)e);
        }
        catch (IOException e) {
            throw new TestAutomationException("TestAutomationConnector : internal error, could not generate json", (Throwable)e);
        }
    }

    protected <R> R safeReadValue(String json, Class<R> clazz) {
        try {
            return (R)this.objMapper.readValue(json, clazz);
        }
        catch (JsonParseException e) {
            throw new UnreadableResponseException("TestAutomationConnector : the response from the server couldn't be treated", (Throwable)e);
        }
        catch (JsonMappingException e) {
            throw new UnreadableResponseException("TestAutomationConnector : the response from the server couldn't be treated", (Throwable)e);
        }
        catch (IOException e) {
            throw new UnreadableResponseException("TestAutomationConnector : internal error :", (Throwable)e);
        }
    }

    protected JobList filterDisabledJobs(JobList fullList) {
        JobList newJobList = new JobList();
        for (Job job : fullList.getJobs()) {
            if (job.getColor().equals(DISABLED_COLOR_STRING)) continue;
            newJobList.getJobs().add(job);
        }
        return newJobList;
    }

    protected Collection<TestAutomationProject> toProjectList(JobList jobList) {
        ArrayList<TestAutomationProject> projects = new ArrayList<TestAutomationProject>();
        for (Job job : jobList.getJobs()) {
            projects.add(new TestAutomationProject(job.getName(), null));
        }
        return projects;
    }
}

