/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.httpclient.HttpClient;
import org.squashtest.tm.domain.testautomation.AutomatedTest;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.FetchTestListStepSequence;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.StepSequence;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.SynchronousBuildProcessor;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.BuildAbsoluteId;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.GatherTestList;

public class FetchTestListBuildProcessor
extends SynchronousBuildProcessor<Collection<AutomatedTest>> {
    private FetchTestListStepSequence stepSequence = new FetchTestListStepSequence(this);
    private TestAutomationProject project;
    private Collection<AutomatedTest> tests = new ArrayList<AutomatedTest>();

    public void setClient(HttpClient client) {
        this.stepSequence.setClient(client);
    }

    public void setProject(TestAutomationProject project) {
        this.stepSequence.setProject(project);
        this.project = project;
    }

    public void setBuildAbsoluteId(BuildAbsoluteId absoluteId) {
        this.stepSequence.setAbsoluteId(absoluteId);
    }

    @Override
    public Collection<AutomatedTest> getResult() {
        return this.tests;
    }

    @Override
    protected void buildResult() {
        if (!this.stepSequence.hasMoreElements()) {
            Collection<String> names = ((GatherTestList)this.currentStep).getTestNames();
            for (String name : names) {
                AutomatedTest test = new AutomatedTest(name, this.project);
                this.tests.add(test);
            }
        } else {
            throw new RuntimeException("tried to build the result before the computation is over, probably due to a buggy thread");
        }
    }

    @Override
    protected StepSequence getStepSequence() {
        return this.stepSequence;
    }
}

