/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.squashtest.tm.domain.testautomation.AutomatedTest;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.service.testautomation.model.TestAutomationProjectContent;

public class TestByProjectSorter {
    private Map<TestAutomationProject, TestAutomationProjectContent> testsByProject;
    private Iterator<TestAutomationProjectContent> iterator;

    public TestByProjectSorter(Collection<AutomatedTest> tests) {
        this.testsByProject = new HashMap<TestAutomationProject, TestAutomationProjectContent>(tests.size());
        for (AutomatedTest test : tests) {
            TestAutomationProject project = test.getProject();
            this.register(project, test);
        }
        this.iterator = this.testsByProject.values().iterator();
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public TestAutomationProjectContent getNext() {
        return this.iterator.next();
    }

    private void register(TestAutomationProject project, AutomatedTest test) {
        if (!this.testsByProject.containsKey(project)) {
            TestAutomationProjectContent newContent = new TestAutomationProjectContent(project, new LinkedList());
            this.testsByProject.put(project, newContent);
        }
        TestAutomationProjectContent content = this.testsByProject.get(project);
        content.getTests().add(test);
    }
}

