/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal;

import java.util.NoSuchElementException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.BuildStage;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.HttpBasedStepSequence;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.AbstractBuildProcessor;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.BuildStep;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.StepSequence;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.BuildAbsoluteId;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.StartBuild;

class FetchTestListStepSequence
extends HttpBasedStepSequence
implements StepSequence {
    private AbstractBuildProcessor processor;

    FetchTestListStepSequence(AbstractBuildProcessor processor) {
        this.processor = processor;
    }

    @Override
    void setClient(HttpClient client) {
        this.client = client;
    }

    @Override
    void setProject(TestAutomationProject project) {
        this.project = project;
    }

    @Override
    void setAbsoluteId(BuildAbsoluteId absoluteId) {
        this.absoluteId = absoluteId;
    }

    @Override
    protected AbstractBuildProcessor getProcessor() {
        return this.processor;
    }

    @Override
    public boolean hasMoreElements() {
        return this.currentStage != BuildStage.GATHER_RESULT;
    }

    @Override
    public BuildStep<?> nextElement() {
        switch (this.currentStage) {
            case WAITING: {
                this.currentStage = BuildStage.START_BUILD;
                return this.newStartBuild();
            }
            case START_BUILD: {
                this.currentStage = BuildStage.CHECK_QUEUE;
                return this.newCheckQueue();
            }
            case CHECK_QUEUE: {
                this.currentStage = BuildStage.GET_BUILD_ID;
                return this.newGetBuildID();
            }
            case GET_BUILD_ID: {
                this.currentStage = BuildStage.CHECK_BUILD_RUNNING;
                return this.newCheckBuildRunning();
            }
            case CHECK_BUILD_RUNNING: {
                this.currentStage = BuildStage.GATHER_RESULT;
                return this.newGatherResults();
            }
            case GATHER_RESULT: {
                throw new NoSuchElementException();
            }
        }
        throw new NoSuchElementException();
    }

    protected StartBuild newStartBuild() {
        PostMethod method = this.requestFactory.newStartFetchTestListBuild(this.project, this.absoluteId.getExternalId());
        StartBuild startBuild = new StartBuild(this.getProcessor());
        this.wireHttpSteps(startBuild, (HttpMethod)method);
        return startBuild;
    }
}

