/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.osgi.extensions.annotation.ServiceReference;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.testautomation.AutomatedTest;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.Build;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.BuildList;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.ExecuteAndWatchBuildProcessor;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.ExecuteTestsBuildProcessor;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.FetchTestListBuildProcessor;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.JsonParser;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.TestByProjectSorter;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.HttpClientProvider;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.HttpRequestFactory;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.RequestExecutor;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.StepEventListener;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.BuildAbsoluteId;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.GetBuildID;
import org.squashtest.tm.service.testautomation.AutomatedExecutionSetIdentifier;
import org.squashtest.tm.service.testautomation.TestAutomationCallbackService;
import org.squashtest.tm.service.testautomation.model.TestAutomationProjectContent;
import org.squashtest.tm.service.testautomation.spi.AccessDenied;
import org.squashtest.tm.service.testautomation.spi.BadConfiguration;
import org.squashtest.tm.service.testautomation.spi.NotFoundException;
import org.squashtest.tm.service.testautomation.spi.ServerConnectionFailed;
import org.squashtest.tm.service.testautomation.spi.TestAutomationConnector;
import org.squashtest.tm.service.testautomation.spi.TestAutomationException;
import org.squashtest.tm.service.testautomation.spi.UnreadableResponseException;

@Service(value="plugin.testautomation.jenkins.connector")
public class TestAutomationJenkinsConnector
implements TestAutomationConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestAutomationConnector.class);
    private static final String CONNECTOR_KIND = "jenkins";
    private static final int DEFAULT_SPAM_INTERVAL_MILLIS = 5000;
    private TaskScheduler taskScheduler;
    private HttpClientProvider clientProvider = new HttpClientProvider();
    private JsonParser jsonParser = new JsonParser();
    private HttpRequestFactory requestFactory = new HttpRequestFactory();
    @Value(value="${tm.test.automation.pollinterval.millis}")
    private int spamInterval = 5000;
    private RequestExecutor requestExecutor = RequestExecutor.getInstance();

    @ServiceReference
    public void setTaskScheduler(TaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }

    public String getConnectorKind() {
        return CONNECTOR_KIND;
    }

    public boolean checkCredentials(TestAutomationServer server) {
        HttpClient client = this.clientProvider.getClientFor(server);
        GetMethod credCheck = this.requestFactory.newCheckCredentialsMethod(server);
        this.requestExecutor.execute(client, (HttpMethod)credCheck);
        return true;
    }

    public Collection<TestAutomationProject> listProjectsOnServer(TestAutomationServer server) throws ServerConnectionFailed, AccessDenied, UnreadableResponseException, BadConfiguration, TestAutomationException {
        HttpClient client = this.clientProvider.getClientFor(server);
        GetMethod getJobsMethod = this.requestFactory.newGetJobsMethod(server);
        String response = this.requestExecutor.execute(client, (HttpMethod)getJobsMethod);
        try {
            return this.jsonParser.readJobListFromJson(response);
        }
        catch (UnreadableResponseException ex) {
            throw new UnreadableResponseException("Test automation - jenkins : server '" + server + "' returned malformed response : ", ex.getCause());
        }
    }

    public Collection<AutomatedTest> listTestsInProject(TestAutomationProject project) throws ServerConnectionFailed, AccessDenied, UnreadableResponseException, NotFoundException, BadConfiguration, TestAutomationException {
        HttpClient client = this.clientProvider.getClientFor(project.getServer());
        FetchTestListBuildProcessor processor = new FetchTestListBuildProcessor();
        processor.setClient(client);
        processor.setProject(project);
        processor.setBuildAbsoluteId(new BuildAbsoluteId(project.getName(), this.generateNewId()));
        processor.setDefaultReschedulingDelay(this.spamInterval);
        processor.run();
        return processor.getResult();
    }

    public void executeTests(Collection<AutomatedTest> tests, String reference) throws ServerConnectionFailed, AccessDenied, UnreadableResponseException, NotFoundException, BadConfiguration, TestAutomationException {
        TestByProjectSorter sorter = new TestByProjectSorter(tests);
        while (sorter.hasNext()) {
            this._startTestExecution(sorter.getNext(), reference);
        }
    }

    public void executeTests(Collection<AutomatedTest> tests, String reference, TestAutomationCallbackService callbackService) throws ServerConnectionFailed, AccessDenied, UnreadableResponseException, NotFoundException, BadConfiguration, TestAutomationException {
        TestByProjectSorter sorter = new TestByProjectSorter(tests);
        while (sorter.hasNext()) {
            this._startTestExecution(sorter.getNext(), reference, callbackService);
        }
    }

    /*
     * Unable to fully structure code
     */
    public Map<AutomatedTest, URL> getResultURLs(Collection<AutomatedTest> tests, String reference) throws ServerConnectionFailed, AccessDenied, UnreadableResponseException, NotFoundException, BadConfiguration, TestAutomationException {
        resultMap = new HashMap<AutomatedTest, URL>(tests.size());
        sorter = new TestByProjectSorter(tests);
        block2: while (sorter.hasNext()) {
            content = sorter.getNext();
            try {
                buildID = this._optimisticGetBuildID(content.getProject(), reference);
                this._createAndAddURLs(resultMap, content, buildID);
                continue;
            }
            catch (TestAutomationException ex) {
                if (TestAutomationJenkinsConnector.LOGGER.isErrorEnabled()) {
                    TestAutomationJenkinsConnector.LOGGER.error("Test Automation : could not create result url due to an inner error : ", (Throwable)ex);
                }
                ** for (test : content.getTests())
            }
lbl-1000:
            // 1 sources

            {
                resultMap.put(test, null);
                continue;
lbl16:
                // 1 sources

            }
        }
        return resultMap;
    }

    private void _startTestExecution(TestAutomationProjectContent content, String externalID) {
        TestAutomationProject project = content.getProject();
        HttpClient client = this.clientProvider.getClientFor(project.getServer());
        ExecuteTestsBuildProcessor processor = new ExecuteTestsBuildProcessor(this.taskScheduler);
        processor.setClient(client);
        processor.setProjectContent(content);
        processor.setBuildAbsoluteId(new BuildAbsoluteId(project.getName(), externalID));
        processor.setDefaultReschedulingDelay(this.spamInterval);
        processor.run();
    }

    private void _startTestExecution(TestAutomationProjectContent content, String externalID, TestAutomationCallbackService service) {
        TestAutomationProject project = content.getProject();
        ResultURLUpdater updater = new ResultURLUpdater(service, content, externalID);
        HttpClient client = this.clientProvider.getClientFor(project.getServer());
        ExecuteAndWatchBuildProcessor processor = new ExecuteAndWatchBuildProcessor(this.taskScheduler);
        processor.setClient(client);
        processor.setProjectContent(content);
        processor.setBuildAbsoluteId(new BuildAbsoluteId(project.getName(), externalID));
        processor.setDefaultReschedulingDelay(this.spamInterval);
        processor.setGetBuildIDListener(updater);
        processor.run();
    }

    private Integer _optimisticGetBuildID(TestAutomationProject project, String externalID) {
        GetMethod method;
        HttpClient client = this.clientProvider.getClientFor(project.getServer());
        String json = this.requestExecutor.execute(client, (HttpMethod)(method = this.requestFactory.newGetBuildsForProject(project)));
        BuildList buildList = this.jsonParser.getBuildListFromJson(json);
        Build buildOfInterest = buildList.findByExternalId(externalID);
        if (buildOfInterest != null) {
            return buildOfInterest.getId();
        }
        throw new NotFoundException("TestAutomationConnector : the requested build for project " + project.getName() + " externalID " + externalID + " cannot be found");
    }

    private void _createAndAddURLs(Map<AutomatedTest, URL> allURLs, TestAutomationProjectContent content, Integer buildID) {
        for (AutomatedTest test : content.getTests()) {
            URL resultURL;
            String resultPath = this.requestFactory.buildResultURL(test, buildID);
            try {
                resultURL = new URL(resultPath);
            }
            catch (MalformedURLException e) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("Test Automation : malformed URL, could not create result url from string '" + resultPath + "'", (Throwable)e);
                }
                resultURL = null;
            }
            allURLs.put(test, resultURL);
        }
    }

    private String generateNewId() {
        return Long.valueOf(System.currentTimeMillis()).toString();
    }

    private class ResultURLUpdater
    implements StepEventListener<GetBuildID> {
        private TestAutomationCallbackService service;
        private TestAutomationProjectContent content;
        private String externalID;

        ResultURLUpdater(TestAutomationCallbackService service, TestAutomationProjectContent content, String externalID) {
            this.service = service;
            this.content = content;
            this.externalID = externalID;
        }

        @Override
        public void onComplete(GetBuildID step) {
            HashMap resultUrlPerTest = new HashMap(this.content.getTests().size());
            Integer buildID = step.getBuildID();
            TestAutomationJenkinsConnector.this._createAndAddURLs(resultUrlPerTest, this.content, buildID);
            for (Map.Entry entry : resultUrlPerTest.entrySet()) {
                AutomatedExecutionSetIdentifier identifier = this.toIdentifier((AutomatedTest)entry.getKey());
                this.service.updateResultURL(identifier, (URL)entry.getValue());
            }
        }

        @Override
        public void onError(GetBuildID step, Exception exception) {
        }

        private AutomatedExecutionSetIdentifier toIdentifier(AutomatedTest test) {
            return new SimpleAutoExecIdentifier(test.getProject().getName(), this.externalID, test.getName());
        }
    }

    private static class SimpleAutoExecIdentifier
    implements AutomatedExecutionSetIdentifier {
        private String testAutomationProjectName;
        private String automatedSuiteId;
        private String automatedTestName;

        public SimpleAutoExecIdentifier(String testAutomationProjectName, String automatedSuiteId, String automatedTestName) {
            this.testAutomationProjectName = testAutomationProjectName;
            this.automatedSuiteId = automatedSuiteId;
            this.automatedTestName = automatedTestName;
        }

        public String getTestAutomationProjectName() {
            return this.testAutomationProjectName;
        }

        public String getAutomatedSuiteId() {
            return this.automatedSuiteId;
        }

        public String getAutomatedTestName() {
            return this.automatedTestName;
        }
    }
}

