/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps;

import java.util.Collection;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.TestList;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.JsonParser;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.RequestExecutor;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.BuildProcessor;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.BuildStep;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.BuildAbsoluteId;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.HttpBasedStep;

public class GatherTestList
extends BuildStep<GatherTestList>
implements HttpBasedStep {
    private RequestExecutor requestExecutor = RequestExecutor.getInstance();
    private HttpClient client;
    private HttpMethod method;
    private JsonParser parser;
    private Collection<String> testNames;

    @Override
    public void setClient(HttpClient client) {
        this.client = client;
    }

    @Override
    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    @Override
    public void setParser(JsonParser parser) {
        this.parser = parser;
    }

    @Override
    public void setBuildAbsoluteId(BuildAbsoluteId absoluteId) {
    }

    public Collection<String> getTestNames() {
        return this.testNames;
    }

    public GatherTestList(BuildProcessor processor) {
        super(processor);
    }

    @Override
    public boolean needsRescheduling() {
        return false;
    }

    @Override
    public void perform() throws Exception {
        String response = this.requestExecutor.execute(this.client, this.method);
        TestList testList = this.parser.getTestListFromJson(response);
        this.testNames = testList.collectAllTestNames();
    }

    @Override
    public void reset() {
        this.testNames = null;
    }

    @Override
    public Integer suggestedReschedulingInterval() {
        return null;
    }
}

