/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal.net;

import java.io.IOException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.csp.tm.testautomation.spi.AccessDenied;
import org.squashtest.csp.tm.testautomation.spi.ServerConnectionFailed;

public class RequestExecutor {
    public static final Logger LOGGER = LoggerFactory.getLogger(RequestExecutor.class);
    public static final RequestExecutor INSTANCE = new RequestExecutor();

    private RequestExecutor() {
    }

    public static RequestExecutor getInstance() {
        return INSTANCE;
    }

    public String execute(HttpClient client, HttpMethod method) {
        try {
            String response;
            int responseCode = client.executeMethod(method);
            this.checkResponseCode(responseCode);
            String string = response = method.getResponseBodyAsString();
            return string;
        }
        catch (AccessDenied accessDenied) {
            throw new AccessDenied("Test automation - jenkins : operation rejected the operation because of wrong credentials");
        }
        catch (IOException ex) {
            throw new ServerConnectionFailed("Test automation - jenkins : could not connect to server due to technical error : ", (Throwable)ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    private void checkResponseCode(int responseCode) {
        if (responseCode == 200) {
            return;
        }
        switch (responseCode) {
            case 401: 
            case 403: 
            case 407: {
                throw new AccessDenied();
            }
        }
    }
}

