/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.squashtest.csp.core.bugtracker.core.UnsupportedAuthenticationModeException;
import org.squashtest.tm.core.foundation.lang.Couple;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.BasicAuthenticationCredentials;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.AutomatedTest;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.BuildDef;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.FetchTestListBuildProcessor;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.JsonParser;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.OptimisticTestList;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.StartTestExecution;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.HttpClientProvider;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.HttpRequestFactory;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.RequestExecutor;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.BuildAbsoluteId;
import org.squashtest.tm.service.servers.CredentialsProvider;
import org.squashtest.tm.service.servers.UserCredentialsCache;
import org.squashtest.tm.service.testautomation.TestAutomationCallbackService;
import org.squashtest.tm.service.testautomation.spi.TestAutomationConnector;
import org.squashtest.tm.service.testautomation.spi.TestAutomationException;
import org.squashtest.tm.service.testautomation.spi.TestAutomationServerNoCredentialsException;
import org.squashtest.tm.service.testautomation.spi.UnreadableResponseException;

@Service(value="plugin.testautomation.jenkins.connector")
public class TestAutomationJenkinsConnector
implements TestAutomationConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestAutomationConnector.class);
    private static final String CONNECTOR_KIND = "jenkins";
    private static final int DEFAULT_SPAM_INTERVAL_MILLIS = 5000;
    private static final String GIVEN_PROTOCOL_NOT_SUPPORTED = "The given protocol %s is not supported.";
    @Inject
    private TaskScheduler taskScheduler;
    @Inject
    private HttpClientProvider clientProvider;
    private JsonParser jsonParser = new JsonParser();
    @Inject
    private HttpRequestFactory requestFactory;
    @Inject
    private CredentialsProvider credentialsProvider;
    @Inject
    private MessageSource i18nHelper;
    @Value(value="${tm.test.automation.pollinterval.millis}")
    private int spamInterval = 5000;
    private RequestExecutor requestExecutor = RequestExecutor.getInstance();

    private String getMessage(String i18nKey) {
        Locale locale = LocaleContextHolder.getLocale();
        return this.i18nHelper.getMessage(i18nKey, null, locale);
    }

    public String getConnectorKind() {
        return CONNECTOR_KIND;
    }

    public boolean checkCredentials(TestAutomationServer server, String login, String password) throws TestAutomationException {
        CloseableHttpClient client = this.clientProvider.getClientFor(server, login, password);
        HttpGet credCheck = this.requestFactory.newCheckCredentialsMethod(server, login, password);
        this.requestExecutor.execute(client, (HttpUriRequest)credCheck);
        return true;
    }

    public boolean checkCredentials(TestAutomationServer server, Credentials credentials) throws TestAutomationException {
        BasicAuthenticationCredentials basicCredentials = (BasicAuthenticationCredentials)credentials;
        CloseableHttpClient client = this.clientProvider.getClientFor(server, basicCredentials.getUsername(), String.valueOf(basicCredentials.getPassword()));
        HttpGet credCheck = this.requestFactory.newCheckCredentialsMethod(server, basicCredentials.getUsername(), String.valueOf(basicCredentials.getPassword()));
        this.requestExecutor.execute(client, (HttpUriRequest)credCheck);
        return true;
    }

    public Collection<TestAutomationProject> listProjectsOnServer(TestAutomationServer server, String login, String password) throws TestAutomationException {
        CloseableHttpClient client = this.clientProvider.getClientFor(server, login, password);
        HttpGet getJobsMethod = this.requestFactory.newGetJobsMethod(server);
        String response = this.requestExecutor.execute(client, (HttpUriRequest)getJobsMethod);
        try {
            return this.jsonParser.readJobListFromJson(response);
        }
        catch (UnreadableResponseException ex) {
            throw new UnreadableResponseException("Test automation - jenkins : server '" + server + "' returned malformed response : ", (Throwable)ex);
        }
    }

    public Collection<TestAutomationProject> listProjectsOnServer(TestAutomationServer server, Credentials credentials) throws TestAutomationException {
        BasicAuthenticationCredentials basicCredentials = (BasicAuthenticationCredentials)credentials;
        CloseableHttpClient client = this.clientProvider.getClientFor(server, basicCredentials.getUsername(), String.valueOf(basicCredentials.getPassword()));
        HttpGet getJobsMethod = this.requestFactory.newGetJobsMethod(server);
        String response = this.requestExecutor.execute(client, (HttpUriRequest)getJobsMethod);
        try {
            return this.jsonParser.readJobListFromJson(response);
        }
        catch (UnreadableResponseException ex) {
            throw new UnreadableResponseException("Test automation - jenkins : server '" + server + "' returned malformed response : ", (Throwable)ex);
        }
    }

    public Collection<AutomatedTest> listTestsInProject(TestAutomationProject project, String username) throws TestAutomationException {
        this.initializeCredentialsCache(username);
        BasicAuthenticationCredentials basicCredentials = this.getAutomationServerCredentials(project.getServer());
        try {
            OptimisticTestList otl = new OptimisticTestList(this.clientProvider, project, basicCredentials);
            Collection<AutomatedTest> collection = otl.run();
            return collection;
        }
        catch (Exception ex) {
            LOGGER.error("Error while fetching job list for project {}.", (Object)project);
            LOGGER.error(ex.toString());
            CloseableHttpClient client = this.clientProvider.getClientFor(project.getServer(), basicCredentials.getUsername(), String.valueOf(basicCredentials.getPassword()));
            FetchTestListBuildProcessor processor = new FetchTestListBuildProcessor();
            processor.setClient(client);
            processor.setProject(project);
            processor.setBuildAbsoluteId(new BuildAbsoluteId(project.getJobName(), this.generateNewId()));
            processor.setDefaultReschedulingDelay(this.spamInterval);
            processor.run();
            Object object = processor.getResult();
            return object;
        }
        finally {
            LOGGER.debug("TestAutomationJenkinsCOnnector : completed test fetching for autoamtion project '{}'", (Object)project.getLabel());
            this.credentialsProvider.unloadCache();
        }
    }

    public void executeParameterizedTests(Collection<Couple<AutomatedExecutionExtender, Map<String, Object>>> parameterizedExecutions, String externalId, TestAutomationCallbackService callbackService) {
        MultiValueMap<TestAutomationProject, Couple<AutomatedExecutionExtender, Map<String, Object>>> execsByProject = this.reduceToParamdExecsByProject(parameterizedExecutions);
        List<BuildDef> buildDefs = this.mapToJobDefs(execsByProject);
        for (BuildDef buildDef : buildDefs) {
            new StartTestExecution(buildDef, this.clientProvider, this.requestFactory, externalId).run();
        }
    }

    private String generateNewId() {
        return Long.toString(System.currentTimeMillis());
    }

    private List<BuildDef> mapToJobDefs(MultiValueMap<TestAutomationProject, Couple<AutomatedExecutionExtender, Map<String, Object>>> execsByProject) {
        ArrayList<BuildDef> jobDefs = new ArrayList<BuildDef>(execsByProject.size());
        for (Map.Entry entry : execsByProject.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            Couple firstEntry = (Couple)((List)entry.getValue()).get(0);
            TestAutomationServer automationServer = ((TestAutomationProject)entry.getKey()).getServer();
            BasicAuthenticationCredentials credentials = this.getAutomationServerCredentials(automationServer);
            jobDefs.add(new BuildDef((TestAutomationProject)entry.getKey(), credentials, (List)entry.getValue(), ((AutomatedExecutionExtender)firstEntry.getA1()).getNodeName()));
        }
        return jobDefs;
    }

    private MultiValueMap<TestAutomationProject, Couple<AutomatedExecutionExtender, Map<String, Object>>> reduceToParamdExecsByProject(Collection<Couple<AutomatedExecutionExtender, Map<String, Object>>> parameterizedExecutions) {
        LinkedMultiValueMap execsByProject = new LinkedMultiValueMap();
        for (Couple<AutomatedExecutionExtender, Map<String, Object>> paramdExec : parameterizedExecutions) {
            execsByProject.add((Object)((AutomatedExecutionExtender)paramdExec.getA1()).getAutomatedProject(), paramdExec);
        }
        return execsByProject;
    }

    private BasicAuthenticationCredentials getAutomationServerCredentials(TestAutomationServer automationServer) {
        Supplier<TestAutomationServerNoCredentialsException> throwIfNull;
        Optional maybeCredentials = this.credentialsProvider.getAppLevelCredentials((ThirdPartyServer)automationServer);
        Credentials credentials = (Credentials)maybeCredentials.orElseThrow(throwIfNull = () -> {
            throw new TestAutomationServerNoCredentialsException(String.format(this.getMessage("message.testAutomationServer.noCredentials"), automationServer.getName()));
        });
        AuthenticationProtocol protocol = credentials.getImplementedProtocol();
        if (!this.supports(protocol)) {
            throw new UnsupportedAuthenticationModeException(protocol.toString());
        }
        return (BasicAuthenticationCredentials)credentials;
    }

    public URL findTestAutomationProjectURL(TestAutomationProject testAutomationProject) {
        String projectUrl = TestAutomationJenkinsConnector.getJobPath(testAutomationProject);
        try {
            return new URL(projectUrl);
        }
        catch (MalformedURLException e) {
            throw new TestAutomationProjectMalformedURLException(projectUrl, e);
        }
    }

    public boolean testListIsOrderGuaranteed(Collection<AutomatedTest> tests) {
        if (tests.isEmpty()) {
            return true;
        }
        Iterator<AutomatedTest> iterator = tests.iterator();
        String firstPath = iterator.next().getPath();
        for (AutomatedTest test : tests) {
            String path = test.getPath();
            if (firstPath.equals(path)) continue;
            return false;
        }
        return true;
    }

    public boolean supports(AuthenticationProtocol authenticationProtocol) {
        switch (authenticationProtocol) {
            case BASIC_AUTH: {
                return true;
            }
            case OAUTH_1A: {
                return false;
            }
        }
        throw new IllegalArgumentException(String.format(GIVEN_PROTOCOL_NOT_SUPPORTED, authenticationProtocol.toString()));
    }

    public AuthenticationProtocol[] getSupportedProtocols() {
        return new AuthenticationProtocol[]{AuthenticationProtocol.BASIC_AUTH};
    }

    public static String getJobPath(TestAutomationProject testAutomationProject) {
        TestAutomationServer server = testAutomationProject.getServer();
        String baseUrl = server.getUrl();
        String jobName = TestAutomationJenkinsConnector.getJobSubPath(testAutomationProject);
        return String.valueOf(baseUrl) + jobName;
    }

    public static String getJobSubPath(TestAutomationProject testAutomationProject) {
        String jobName = StringUtils.prependIfMissing((String)testAutomationProject.getJobName(), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        jobName = jobName.replace("/", "/job/");
        return jobName;
    }

    private void initializeCredentialsCache(String username) {
        LOGGER.debug("TestAutomationJenkinsConnector : initializing the credentials cache");
        UserCredentialsCache credentials = new UserCredentialsCache(username);
        this.credentialsProvider.restoreCache(credentials);
    }

    public class TestAutomationProjectMalformedURLException
    extends RuntimeException {
        private static final long serialVersionUID = -4904491027261699261L;

        public TestAutomationProjectMalformedURLException(String projectUrl, Exception e) {
            super("The test automation project url : " + projectUrl + ", is malformed", e);
        }
    }
}

