/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.http.client.utils.URIBuilder;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;
import org.squashtest.tm.core.foundation.lang.Couple;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.plugin.testautomation.jenkins.TestAutomationJenkinsConnector;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.JenkinsCrumb;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.ParameterArray;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.BuildDef;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.HttpClientProvider;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.HttpRequestFactory;
import org.squashtest.tm.service.testautomation.spi.AccessDenied;
import org.squashtest.tm.service.testautomation.spi.NotFoundException;
import org.squashtest.tm.service.testautomation.spi.ServerConnectionFailed;
import org.squashtest.tm.service.testautomation.spi.TestAutomationException;

public class StartTestExecution {
    private static final Logger LOGGER = LoggerFactory.getLogger(StartTestExecution.class);
    private static final String UNUSED = "unused";
    private final BuildDef buildDef;
    private final HttpClientProvider clientProvider;
    private final String externalId;
    private RestTemplate template;

    public StartTestExecution(BuildDef buildDef, HttpClientProvider clientProvider, String externalId) {
        this.buildDef = buildDef;
        this.clientProvider = clientProvider;
        this.externalId = externalId;
        this.template = new RestTemplate(clientProvider.getRequestFactoryFor(buildDef.getProject().getServer()));
    }

    public void run() {
        TestAutomationProject project = this.buildDef.getProject();
        JenkinsCrumb crumb = this.getCrumb(project.getServer());
        URI url = this.createUrl(project);
        MultiValueMap<String, ?> postData = this.createPostData(this.buildDef, this.externalId);
        Object bime = this.execute(url, crumb, postData);
        LOGGER.info("started build {}", bime);
    }

    private Object execute(URI url, JenkinsCrumb crumb, MultiValueMap<String, ?> postData) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.MULTIPART_FORM_DATA);
            if (crumb != null) {
                headers.add(crumb.getCrumbRequestField(), crumb.getCrumb());
            }
            RequestEntity request = new RequestEntity(postData, (MultiValueMap)headers, HttpMethod.POST, url);
            return this.template.exchange(request, Void.class);
        }
        catch (ResourceAccessException ex) {
            throw new ServerConnectionFailed((Throwable)ex);
        }
        catch (HttpClientErrorException ex) {
            switch (ex.getStatusCode()) {
                case UNAUTHORIZED: 
                case FORBIDDEN: 
                case PROXY_AUTHENTICATION_REQUIRED: {
                    throw new AccessDenied();
                }
                case NOT_FOUND: {
                    throw new NotFoundException((Throwable)ex);
                }
            }
            throw new TestAutomationException(ex.getMessage(), (Throwable)ex);
        }
        catch (HttpServerErrorException ex) {
            LOGGER.error("build fail due to Jenkins error. Root error is :");
            LOGGER.error(ex.getMessage());
            LOGGER.error(ex.getResponseBodyAsString());
            throw new TestAutomationException(ex.getMessage(), (Throwable)ex);
        }
    }

    private JenkinsCrumb getCrumb(TestAutomationServer server) {
        try {
            LOGGER.trace("fetching CSRF jenkins crumb");
            URI uri = new URI(server.getBaseURL() + "/crumbIssuer/api/json");
            LOGGER.trace("crumb found");
            return (JenkinsCrumb)this.template.getForObject(uri, JenkinsCrumb.class);
        }
        catch (HttpClientErrorException e) {
            if (e.getStatusCode() == HttpStatus.NOT_FOUND) {
                LOGGER.trace("no crumb found, CSRF protection seems disabled");
                return null;
            }
            throw new ServerConnectionFailed((Throwable)e);
        }
        catch (URISyntaxException ex) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("cannot fetch crumb from server '" + server.getBaseURL() + "' due to URI syntax exception. Is the server URL correct ?");
            }
            throw new RuntimeException(ex);
        }
    }

    private URI createUrl(TestAutomationProject project) {
        TestAutomationServer server = project.getServer();
        String jobSubPath = TestAutomationJenkinsConnector.getJobSubPath(project);
        try {
            URI base = new URI(server.getBaseURL().toString());
            return new URIBuilder(base).setPath(String.valueOf(base.getPath()) + jobSubPath + "/build").build();
        }
        catch (URISyntaxException use) {
            LOGGER.error("cannot execute build for job {} hosted on server {}. Job Sub path is {}. due to URI syntax exception. Is the server URL correct ?", new Object[]{project.getJobName(), project.getServer().getBaseURL(), jobSubPath});
            throw new RuntimeException(use);
        }
    }

    private MultiValueMap<String, ?> createPostData(BuildDef buildDef, String externalId) {
        LinkedMultiValueMap parts = new LinkedMultiValueMap();
        ParameterArray stdParams = new HttpRequestFactory().getStartTestSuiteBuildParameters(externalId, buildDef.getNode());
        try {
            File tmp = this.createJsonSuite(buildDef);
            parts.add((Object)"file0", (Object)new FileSystemResource(tmp));
            parts.add((Object)"json", (Object)new ObjectMapper().writeValueAsString((Object)stdParams));
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Error while mashalling json model. Maybe a bug ?", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("Error while writing json model into temp file. Maybe temp folder is not writable ?", (Throwable)e);
        }
        return parts;
    }

    private File createJsonSuite(BuildDef buildDef) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        File tmp = File.createTempFile("ta-suite", ".json");
        tmp.deleteOnExit();
        objectMapper.writeValue(tmp, (Object)new JsonSuiteAdapter(buildDef));
        return tmp;
    }

    private static final class JsonSuiteAdapter {
        private final BuildDef buildDef;
        private List<JsonTestAdapter> tests;

        private JsonSuiteAdapter(BuildDef buildDef) {
            this.buildDef = buildDef;
        }

        public List<JsonTestAdapter> getTest() {
            if (this.tests == null) {
                this.tests = new ArrayList<JsonTestAdapter>();
                for (Couple<AutomatedExecutionExtender, Map<String, Object>> paramdExec : this.buildDef.getParameterizedExecutions()) {
                    JsonTestAdapter json = new JsonTestAdapter(paramdExec);
                    this.tests.add(json);
                }
            }
            return this.tests;
        }
    }

    private static final class JsonTestAdapter {
        private final Couple<AutomatedExecutionExtender, Map<String, Object>> paramdExec;

        private JsonTestAdapter(@NotNull Couple<AutomatedExecutionExtender, Map<String, Object>> paramdExec) {
            this.paramdExec = paramdExec;
        }

        public String getScript() {
            return ((AutomatedExecutionExtender)this.paramdExec.getA1()).getAutomatedTest().getName();
        }

        public String getId() {
            return ((AutomatedExecutionExtender)this.paramdExec.getA1()).getId().toString();
        }

        public Map<String, Object> getParam() {
            return (Map)this.paramdExec.getA2();
        }
    }
}

