/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks;

import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import org.springframework.scheduling.TaskScheduler;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.BuildStep;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.StepFuture;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.StepScheduler;

public class ThreadPoolStepScheduler
implements StepScheduler {
    private TaskScheduler scheduler;

    public TaskScheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(TaskScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public ThreadPoolStepScheduler() {
    }

    public ThreadPoolStepScheduler(TaskScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public StepFuture schedule(BuildStep step, int millisDelay) {
        Date startTime = new Date(System.currentTimeMillis() + (long)millisDelay);
        ScheduledFuture future = this.scheduler.schedule((Runnable)step, startTime);
        return new ScheduledFutureWrapper(future);
    }

    public StepFuture schedule(BuildStep step) {
        return this.schedule(step, 0);
    }

    private static class ScheduledFutureWrapper
    implements StepFuture {
        private ScheduledFuture<?> future;

        public ScheduledFutureWrapper(ScheduledFuture<?> future) {
            this.future = future;
        }

        @Override
        public void cancel() {
            if (!this.future.isCancelled() && !this.future.isDone()) {
                this.future.cancel(false);
            }
        }
    }
}

