/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.Build;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.BuildList;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.ItemList;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.Job;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.JobList;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.TestListElement;
import org.squashtest.tm.service.testautomation.spi.TestAutomationException;
import org.squashtest.tm.service.testautomation.spi.UnreadableResponseException;

public class JsonParser {
    private static final String DISABLED_COLOR_STRING = "disabled";
    private ObjectMapper objMapper = new ObjectMapper();

    public JsonParser() {
        this.objMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public Collection<TestAutomationProject> readJobListFromJson(String json) {
        try {
            JobList list = (JobList)this.objMapper.readValue(json, JobList.class);
            JobList filteredList = this.filterDisabledJobs(list);
            return this.toProjectList(filteredList);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new UnreadableResponseException(e);
        }
        catch (IOException e) {
            throw new UnreadableResponseException((Throwable)e);
        }
    }

    public ItemList getQueuedListFromJson(String json) {
        return this.safeReadValue(json, ItemList.class);
    }

    public BuildList getBuildListFromJson(String json) {
        return this.safeReadValue(json, BuildList.class);
    }

    public TestListElement getTestListFromJson(String json) {
        return this.safeReadValue(json, TestListElement.class);
    }

    public Build getBuildFromJson(String json) {
        return this.safeReadValue(json, Build.class);
    }

    public String toJson(Object object) {
        try {
            return this.objMapper.writeValueAsString(object);
        }
        catch (JsonGenerationException | JsonMappingException e) {
            throw new TestAutomationException("TestAutomationConnector : internal error, could not generate json", e);
        }
        catch (IOException e) {
            throw new TestAutomationException("TestAutomationConnector : internal error, could not generate json", (Throwable)e);
        }
    }

    protected <R> R safeReadValue(String json, Class<R> clazz) {
        try {
            return (R)this.objMapper.readValue(json, clazz);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new UnreadableResponseException("TestAutomationConnector : the response from the server couldn't be treated", e);
        }
        catch (IOException e) {
            throw new UnreadableResponseException("TestAutomationConnector : internal error :", (Throwable)e);
        }
    }

    protected JobList filterDisabledJobs(JobList fullList) {
        JobList newJobList = new JobList();
        for (Job job : fullList.getJobs()) {
            if (job.getColor().equals(DISABLED_COLOR_STRING)) continue;
            newJobList.getJobs().add(job);
        }
        return newJobList;
    }

    protected Collection<TestAutomationProject> toProjectList(JobList jobList) {
        ArrayList<TestAutomationProject> projects = new ArrayList<TestAutomationProject>();
        for (Job job : jobList.getJobs()) {
            projects.add(new TestAutomationProject(job.getName()));
        }
        return projects;
    }
}

