/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.squashtest.tm.core.foundation.lang.Couple;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.AutomatedTest;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.BuildDef;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.FetchTestListBuildProcessor;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.JsonParser;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.OptimisticTestList;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.StartTestExecution;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.HttpClientProvider;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.HttpRequestFactory;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.RequestExecutor;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.BuildAbsoluteId;
import org.squashtest.tm.service.testautomation.TestAutomationCallbackService;
import org.squashtest.tm.service.testautomation.spi.TestAutomationConnector;
import org.squashtest.tm.service.testautomation.spi.TestAutomationException;
import org.squashtest.tm.service.testautomation.spi.UnreadableResponseException;

@Service(value="plugin.testautomation.jenkins.connector")
public class TestAutomationJenkinsConnector
implements TestAutomationConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestAutomationConnector.class);
    private static final String CONNECTOR_KIND = "jenkins";
    private static final int DEFAULT_SPAM_INTERVAL_MILLIS = 5000;
    @Inject
    private TaskScheduler taskScheduler;
    @Inject
    private HttpClientProvider clientProvider;
    private JsonParser jsonParser = new JsonParser();
    private HttpRequestFactory requestFactory = new HttpRequestFactory();
    @Value(value="${tm.test.automation.pollinterval.millis}")
    private int spamInterval = 5000;
    private RequestExecutor requestExecutor = RequestExecutor.getInstance();

    public String getConnectorKind() {
        return CONNECTOR_KIND;
    }

    public boolean checkCredentials(TestAutomationServer server) {
        CloseableHttpClient client = this.clientProvider.getClientFor(server);
        HttpGet credCheck = this.requestFactory.newCheckCredentialsMethod(server);
        this.requestExecutor.execute(client, (HttpUriRequest)credCheck);
        return true;
    }

    public Collection<TestAutomationProject> listProjectsOnServer(TestAutomationServer server) throws TestAutomationException {
        CloseableHttpClient client = this.clientProvider.getClientFor(server);
        HttpGet getJobsMethod = this.requestFactory.newGetJobsMethod(server);
        String response = this.requestExecutor.execute(client, (HttpUriRequest)getJobsMethod);
        try {
            return this.jsonParser.readJobListFromJson(response);
        }
        catch (UnreadableResponseException ex) {
            throw new UnreadableResponseException("Test automation - jenkins : server '" + server + "' returned malformed response : ", ex.getCause());
        }
    }

    public Collection<AutomatedTest> listTestsInProject(TestAutomationProject project) throws TestAutomationException {
        try {
            OptimisticTestList otl = new OptimisticTestList(this.clientProvider, project);
            return otl.run();
        }
        catch (Exception exception) {
            CloseableHttpClient client = this.clientProvider.getClientFor(project.getServer());
            FetchTestListBuildProcessor processor = new FetchTestListBuildProcessor();
            processor.setClient(client);
            processor.setProject(project);
            processor.setBuildAbsoluteId(new BuildAbsoluteId(project.getJobName(), this.generateNewId()));
            processor.setDefaultReschedulingDelay(this.spamInterval);
            processor.run();
            return processor.getResult();
        }
    }

    public void executeParameterizedTests(Collection<Couple<AutomatedExecutionExtender, Map<String, Object>>> parameterizedExecutions, String externalId, TestAutomationCallbackService callbackService) {
        MultiValueMap<TestAutomationProject, Couple<AutomatedExecutionExtender, Map<String, Object>>> execsByProject = this.reduceToParamdExecsByProject(parameterizedExecutions);
        List<BuildDef> buildDefs = this.mapToJobDefs(execsByProject);
        for (BuildDef buildDef : buildDefs) {
            new StartTestExecution(buildDef, this.clientProvider, externalId).run();
        }
    }

    private String generateNewId() {
        return Long.toString(System.currentTimeMillis());
    }

    private List<BuildDef> mapToJobDefs(MultiValueMap<TestAutomationProject, Couple<AutomatedExecutionExtender, Map<String, Object>>> execsByProject) {
        ArrayList<BuildDef> jobDefs = new ArrayList<BuildDef>(execsByProject.size());
        for (Map.Entry entry : execsByProject.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            Couple firstEntry = (Couple)((List)entry.getValue()).get(0);
            jobDefs.add(new BuildDef((TestAutomationProject)entry.getKey(), (List)entry.getValue(), ((AutomatedExecutionExtender)firstEntry.getA1()).getNodeName()));
        }
        return jobDefs;
    }

    private MultiValueMap<TestAutomationProject, Couple<AutomatedExecutionExtender, Map<String, Object>>> reduceToParamdExecsByProject(Collection<Couple<AutomatedExecutionExtender, Map<String, Object>>> parameterizedExecutions) {
        LinkedMultiValueMap execsByProject = new LinkedMultiValueMap();
        for (Couple<AutomatedExecutionExtender, Map<String, Object>> paramdExec : parameterizedExecutions) {
            execsByProject.add((Object)((AutomatedExecutionExtender)paramdExec.getA1()).getAutomatedProject(), paramdExec);
        }
        return execsByProject;
    }

    public URL findTestAutomationProjectURL(TestAutomationProject testAutomationProject) {
        TestAutomationServer server = testAutomationProject.getServer();
        String projectUrl = String.valueOf(server.getBaseURL().toString()) + "/job/" + testAutomationProject.getJobName();
        try {
            return new URL(projectUrl);
        }
        catch (MalformedURLException e) {
            throw new TestAutomationProjectMalformedURLException(projectUrl, e);
        }
    }

    public boolean testListIsOrderGuaranteed(Collection<AutomatedTest> tests) {
        if (tests.isEmpty()) {
            return true;
        }
        Iterator<AutomatedTest> iterator = tests.iterator();
        String firstPath = iterator.next().getPath();
        for (AutomatedTest test : tests) {
            String path = test.getPath();
            if (firstPath.equals(path)) continue;
            return false;
        }
        return true;
    }

    public class TestAutomationProjectMalformedURLException
    extends RuntimeException {
        private static final long serialVersionUID = -4904491027261699261L;

        public TestAutomationProjectMalformedURLException(String projectUrl, Exception e) {
            super("The test automation project url : " + projectUrl + ", is malformed", e);
        }
    }
}

