/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal.net;

import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.service.testautomation.spi.AccessDenied;
import org.squashtest.tm.service.testautomation.spi.ServerConnectionFailed;

public class RequestExecutor {
    public static final Logger LOGGER = LoggerFactory.getLogger(RequestExecutor.class);
    private static RequestExecutor INSTANCE = new RequestExecutor();

    private RequestExecutor() {
    }

    public static RequestExecutor getInstance() {
        return INSTANCE;
    }

    public String execute(CloseableHttpClient client, HttpUriRequest method) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (CloseableHttpResponse resp = client.execute(method);){
                this.checkResponseCode(resp.getStatusLine());
                BasicResponseHandler handler = new BasicResponseHandler();
                return (String)handler.handleResponse((HttpResponse)resp);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (AccessDenied accessDenied) {
            throw new AccessDenied("Test automation - jenkins : operation rejected the operation because of wrong credentials");
        }
        catch (IOException ex) {
            throw new ServerConnectionFailed("Test automation - jenkins : could not connect to server due to technical error : ", (Throwable)ex);
        }
    }

    private void checkResponseCode(StatusLine statusLine) {
        int sc = statusLine.getStatusCode();
        if (sc == 200) {
            return;
        }
        switch (sc) {
            case 401: 
            case 403: 
            case 407: {
                throw new AccessDenied();
            }
        }
    }
}

