/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.squashtest.tm.domain.testautomation.AutomatedTest;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.TestListElement;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.JsonParser;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.HttpClientProvider;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.HttpRequestFactory;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.RequestExecutor;

public class OptimisticTestList {
    private HttpClientProvider clientProvider;
    private TestAutomationProject project;
    private JsonParser parser = new JsonParser();

    public OptimisticTestList(HttpClientProvider clientProvider, TestAutomationProject project) {
        this.clientProvider = clientProvider;
        this.project = project;
    }

    public Collection<AutomatedTest> run() {
        CloseableHttpClient client = this.clientProvider.getClientFor(this.project.getServer());
        HttpGet method = new HttpRequestFactory().newGetJsonTestList(this.project);
        try {
            String response = RequestExecutor.getInstance().execute(client, (HttpUriRequest)method);
            TestListElement testList = this.parser.getTestListFromJson(response);
            LinkedList<AutomatedTest> tests = new LinkedList<AutomatedTest>();
            for (String name : testList.collectAllTestNames()) {
                AutomatedTest test = new AutomatedTest(name, this.project);
                tests.add(test);
            }
            LinkedList<AutomatedTest> linkedList = tests;
            return linkedList;
        }
        finally {
            method.releaseConnection();
        }
    }
}

