/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal.net;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;

@Component
public class HttpClientProvider {
    private CredentialsProvider credentialsProvider = new BasicCredentialsProvider();
    private Set<ServerKey> knownServers = new HashSet<ServerKey>();
    private final CloseableHttpClient client;
    private final ClientHttpRequestFactory requestFactory;

    public HttpClientProvider() {
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager();
        manager.setMaxTotal(25);
        this.client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)manager).addInterceptorFirst((HttpRequestInterceptor)new PreemptiveAuthInterceptor()).setDefaultCredentialsProvider(this.credentialsProvider).build();
        this.requestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)this.client);
    }

    public CloseableHttpClient getClientFor(TestAutomationServer server) {
        ServerKey key = new ServerKey(server);
        if (!this.knownServers.contains(key)) {
            this.registerServer(server);
        }
        return this.client;
    }

    public ClientHttpRequestFactory getRequestFactoryFor(TestAutomationServer server) {
        this.getClientFor(server);
        return this.requestFactory;
    }

    protected void registerServer(TestAutomationServer server) {
        URL baseURL = server.getBaseURL();
        this.credentialsProvider.setCredentials(new AuthScope(baseURL.getHost(), baseURL.getPort(), AuthScope.ANY_REALM), (Credentials)new UsernamePasswordCredentials(server.getLogin(), server.getPassword()));
    }

    static class PreemptiveAuthInterceptor
    implements HttpRequestInterceptor {
        PreemptiveAuthInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState.getAuthScheme() == null) {
                BasicScheme authScheme = new BasicScheme();
                CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
                if (authScheme != null) {
                    Credentials creds = credsProvider.getCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()));
                    if (creds == null) {
                        throw new HttpException("No credentials for preemptive authentication");
                    }
                    authState.setAuthScheme((AuthScheme)authScheme);
                    authState.setCredentials(creds);
                }
            }
        }
    }

    private static class ServerKey {
        private String serverURL;
        private String serverLogin;
        private String serverPass;
        private String serverKind;

        public ServerKey(TestAutomationServer server) {
            this.serverURL = server.getBaseURL().toExternalForm();
            this.serverLogin = server.getLogin();
            this.serverPass = server.getPassword();
            this.serverKind = server.getKind();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.serverKind == null ? 0 : this.serverKind.hashCode());
            result = 31 * result + (this.serverLogin == null ? 0 : this.serverLogin.hashCode());
            result = 31 * result + (this.serverPass == null ? 0 : this.serverPass.hashCode());
            result = 31 * result + (this.serverURL == null ? 0 : this.serverURL.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ServerKey other = (ServerKey)obj;
            if (this.serverKind == null ? other.serverKind != null : !this.serverKind.equals(other.serverKind)) {
                return false;
            }
            if (this.serverLogin == null ? other.serverLogin != null : !this.serverLogin.equals(other.serverLogin)) {
                return false;
            }
            if (this.serverPass == null ? other.serverPass != null : !this.serverPass.equals(other.serverPass)) {
                return false;
            }
            return !(this.serverURL == null ? other.serverURL != null : !this.serverURL.equals(other.serverURL));
        }
    }
}

