/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal.net;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.domain.testautomation.AutomatedTest;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.FileParameter;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.Parameter;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.ParameterArray;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.JsonParser;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.CallbackURL;
import org.squashtest.tm.service.testautomation.spi.BadConfiguration;
import org.squashtest.tm.service.testautomation.spi.TestAutomationException;

public class HttpRequestFactory {
    private static final String JOB_PATH = "/job/";
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequestFactory.class);
    private static final String API_URI = "/api/json";
    private static final String TREE = "tree";
    public static final String SYMBOLIC_BUILDFILENAME = "testsuite.json";
    public static final String MULTIPART_BUILDFILENAME = "file0";
    public static final String MULTIPART_JENKINSARGS = "json";
    private static final NameValuePair[] JOB_LIST_QUERY = new NameValuePair[]{new BasicNameValuePair("tree", "jobs[name,color]")};
    private static final NameValuePair[] QUEUED_BUILDS_QUERY = new NameValuePair[]{new BasicNameValuePair("tree", "items[id,actions[parameters[name,value]],task[name]]")};
    private static final NameValuePair[] EXISTING_BUILDS_QUERY = new NameValuePair[]{new BasicNameValuePair("tree", "builds[building,number,actions[parameters[name,value]]]")};
    private static final NameValuePair[] SINGLE_BUILD_QUERY = new NameValuePair[]{new BasicNameValuePair("tree", "building,number,actions[parameters[name,value]]")};
    private static final NameValuePair[] BUILD_RESULT_QUERY = new NameValuePair[]{new BasicNameValuePair("tree", "suites[name,cases[name,status]]")};
    private final JsonParser jsonParser = new JsonParser();
    private final CallbackURLProvider callbackProvider = new CallbackURLProvider();

    public String newRandomId() {
        return Long.valueOf(System.currentTimeMillis()).toString();
    }

    public HttpGet newCheckCredentialsMethod(TestAutomationServer server) {
        URIBuilder builder = this.buildApiPath(server);
        HttpGet method = new HttpGet(this.build(builder));
        String logPass = String.valueOf(server.getLogin()) + ":" + server.getPassword();
        String auth = new String(Base64.encodeBase64((byte[])logPass.getBytes()));
        method.addHeader("Authorization", "Basic " + auth);
        return method;
    }

    private URIBuilder buildApiPath(TestAutomationServer server) {
        return this.uriBuilder(server).setPath(API_URI);
    }

    public HttpGet newGetJobsMethod(TestAutomationServer server) {
        URIBuilder builder = this.buildApiPath(server);
        builder.setParameters(JOB_LIST_QUERY);
        return new HttpGet(this.build(builder));
    }

    public HttpPost newStartFetchTestListBuild(TestAutomationProject project, String externalID) {
        ParameterArray params = new ParameterArray(new Parameter[]{Parameter.operationTestListParameter(), Parameter.newExtIdParameter(externalID)});
        return this.newStartBuild(project, params);
    }

    public ParameterArray getStartTestSuiteBuildParameters(String externalID) {
        String strURL = this.callbackProvider.get().toExternalForm();
        return new ParameterArray(new Object[]{Parameter.operationRunSuiteParameter(), Parameter.newExtIdParameter(externalID), Parameter.newCallbackURlParameter(strURL), Parameter.testListParameter(), new FileParameter(SYMBOLIC_BUILDFILENAME, MULTIPART_BUILDFILENAME)});
    }

    public ParameterArray getStartTestSuiteBuildParameters(String externalID, String executor) {
        String strURL = this.callbackProvider.get().toExternalForm();
        if (StringUtils.isBlank((CharSequence)executor)) {
            return this.getStartTestSuiteBuildParameters(externalID);
        }
        return new ParameterArray(new Object[]{Parameter.operationRunSuiteParameter(), Parameter.newExtIdParameter(externalID), Parameter.newCallbackURlParameter(strURL), Parameter.testListParameter(), Parameter.executorParameter(executor), new FileParameter(SYMBOLIC_BUILDFILENAME, MULTIPART_BUILDFILENAME)});
    }

    public HttpGet newCheckQueue(TestAutomationProject project) {
        TestAutomationServer server = project.getServer();
        URIBuilder builder = this.uriBuilder(server);
        builder.setPath("/queue/api/json").setParameters(QUEUED_BUILDS_QUERY);
        return new HttpGet(this.build(builder));
    }

    private URIBuilder uriBuilder(TestAutomationServer server) {
        try {
            return new URIBuilder(server.getBaseURL().toURI());
        }
        catch (URISyntaxException ex) {
            throw this.handleUriException(ex);
        }
    }

    public HttpGet newGetBuildsForProject(TestAutomationProject project) {
        URIBuilder builder = this.uriBuilder(project.getServer());
        builder.setPath(JOB_PATH + project.getJobName() + API_URI).setParameters(EXISTING_BUILDS_QUERY);
        return new HttpGet(this.build(builder));
    }

    public HttpGet newGetBuild(TestAutomationProject project, int buildId) {
        URIBuilder builder = this.uriBuilder(project.getServer());
        builder.setPath(JOB_PATH + project.getJobName() + '/' + buildId + '/' + API_URI).setParameters(SINGLE_BUILD_QUERY);
        return new HttpGet(this.build(builder));
    }

    public HttpGet newGetBuildResults(TestAutomationProject project, int buildId) {
        URIBuilder builder = this.uriBuilder(project.getServer());
        builder.setPath(JOB_PATH + project.getJobName() + '/' + buildId + "/testReport/" + API_URI).setParameters(BUILD_RESULT_QUERY);
        return new HttpGet(this.build(builder));
    }

    public HttpGet newGetJsonTestList(TestAutomationProject project) {
        URIBuilder builder = this.uriBuilder(project.getServer());
        builder.setPath(JOB_PATH + project.getJobName() + "/Test_list/testTree.json");
        return new HttpGet(this.build(builder));
    }

    public String buildResultURL(AutomatedTest test, Integer buildID) {
        TestAutomationProject project = test.getProject();
        String relativePath = this.toRelativePath(test);
        URIBuilder builder = this.uriBuilder(project.getServer());
        builder.setPath(JOB_PATH + project.getJobName() + "/" + buildID + "/testReport/" + relativePath);
        return builder.toString();
    }

    protected HttpPost newStartBuild(TestAutomationProject project, ParameterArray params) {
        URIBuilder builder = this.uriBuilder(project.getServer());
        builder.setPath(JOB_PATH + project.getJobName() + "/build");
        String jsonParam = this.jsonParser.toJson(params);
        builder.setParameter(MULTIPART_JENKINSARGS, jsonParam);
        return new HttpPost(this.build(builder));
    }

    private URI build(URIBuilder builder) {
        try {
            return builder.build();
        }
        catch (URISyntaxException ex) {
            throw this.handleUriException(ex);
        }
    }

    private TestAutomationException handleUriException(URISyntaxException ex) {
        LOGGER.error("HttpRequestFactory : the URI is invalid, and that was not supposed to happen.");
        return new TestAutomationException((Throwable)ex);
    }

    private String toRelativePath(AutomatedTest test) {
        String name = "";
        if (test.isAtTheRoot()) {
            name = "(root)/";
        }
        name = String.valueOf(name) + test.getPath() + test.getShortName().replaceAll("[-\\.]", "_");
        return name;
    }

    private static class CallbackURLProvider {
        private CallbackURLProvider() {
        }

        public URL get() {
            CallbackURL callback = CallbackURL.getInstance();
            String strURL = callback.getValue();
            try {
                return new URL(strURL);
            }
            catch (MalformedURLException ex) {
                BadConfiguration bc = new BadConfiguration("Test Automation configuration : The test could not be started because the service is not configured properly. The url '" + strURL + "' specified at property '" + callback.getConfPropertyName() + "' in configuration file 'tm.testautomation.conf.properties' is malformed. Please contact the administration team.", (Throwable)ex);
                bc.setPropertyName(callback.getConfPropertyName());
                throw bc;
            }
        }
    }
}

