/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;
import org.squashtest.tm.core.foundation.lang.Couple;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.ParameterArray;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.BuildDef;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.HttpClientProvider;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.HttpRequestFactory;
import org.squashtest.tm.service.testautomation.spi.AccessDenied;
import org.squashtest.tm.service.testautomation.spi.NotFoundException;
import org.squashtest.tm.service.testautomation.spi.ServerConnectionFailed;
import org.squashtest.tm.service.testautomation.spi.TestAutomationException;

public class StartTestExecution {
    private static final Logger LOGGER = LoggerFactory.getLogger(StartTestExecution.class);
    private static final String UNUSED = "unused";
    private final BuildDef buildDef;
    private final HttpClientProvider clientProvider;
    private final String externalId;

    public StartTestExecution(BuildDef buildDef, HttpClientProvider clientProvider, String externalId) {
        this.buildDef = buildDef;
        this.clientProvider = clientProvider;
        this.externalId = externalId;
    }

    public void run() {
        TestAutomationProject project = this.buildDef.getProject();
        TestAutomationServer server = project.getServer();
        RestTemplate template = new RestTemplate(this.clientProvider.getRequestFactoryFor(project.getServer()));
        String url = this.createUrl(server);
        Map<String, ?> urlParams = this.createUrlParams(project);
        MultiValueMap<String, ?> postData = this.createPostData(this.buildDef, this.externalId);
        Object bime = this.execute(template, url, postData, urlParams);
        LOGGER.info("started build {}", bime);
    }

    private Object execute(RestTemplate template, String url, MultiValueMap<String, ?> postData, Map<String, ?> urlParams) {
        try {
            return template.postForLocation(url, postData, urlParams);
        }
        catch (ResourceAccessException resourceAccessException) {
            throw new ServerConnectionFailed();
        }
        catch (HttpClientErrorException ex) {
            switch (ex.getStatusCode()) {
                case UNAUTHORIZED: 
                case FORBIDDEN: 
                case PROXY_AUTHENTICATION_REQUIRED: {
                    throw new AccessDenied();
                }
                case NOT_FOUND: {
                    throw new NotFoundException();
                }
            }
            throw new TestAutomationException(ex.getMessage());
        }
    }

    private String createUrl(TestAutomationServer server) {
        return String.valueOf(server.getBaseURL().toString()) + "/job/{jobName}/build";
    }

    private Map<String, ?> createUrlParams(TestAutomationProject project) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("jobName", project.getJobName());
        return params;
    }

    private MultiValueMap<String, ?> createPostData(BuildDef buildDef, String externalId) {
        LinkedMultiValueMap parts = new LinkedMultiValueMap();
        ParameterArray stdParams = new HttpRequestFactory().getStartTestSuiteBuildParameters(externalId, buildDef.getNode());
        try {
            File tmp = this.createJsonSuite(buildDef);
            parts.add((Object)"file0", (Object)new FileSystemResource(tmp));
            parts.add((Object)"json", (Object)new ObjectMapper().writeValueAsString((Object)stdParams));
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Error while mashalling json model. Maybe a bug ?", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("Error while writing json model into temp file. Maybe temp folder is not writable ?", (Throwable)e);
        }
        return parts;
    }

    private File createJsonSuite(BuildDef buildDef) throws IOException, JsonGenerationException, JsonMappingException {
        ObjectMapper objectMapper = new ObjectMapper();
        File tmp = File.createTempFile("ta-suite", ".json");
        tmp.deleteOnExit();
        objectMapper.writeValue(tmp, (Object)new JsonSuiteAdapter(buildDef));
        return tmp;
    }

    private static final class JsonSuiteAdapter {
        private final BuildDef buildDef;
        private List<JsonTestAdapter> tests;

        private JsonSuiteAdapter(BuildDef buildDef) {
            this.buildDef = buildDef;
        }

        public List<JsonTestAdapter> getTest() {
            if (this.tests == null) {
                this.tests = new ArrayList<JsonTestAdapter>();
                for (Couple<AutomatedExecutionExtender, Map<String, Object>> paramdExec : this.buildDef.getParameterizedExecutions()) {
                    JsonTestAdapter json = new JsonTestAdapter(paramdExec);
                    this.tests.add(json);
                }
            }
            return this.tests;
        }
    }

    private static final class JsonTestAdapter {
        private final Couple<AutomatedExecutionExtender, Map<String, Object>> paramdExec;

        private JsonTestAdapter(@NotNull Couple<AutomatedExecutionExtender, Map<String, Object>> paramdExec) {
            this.paramdExec = paramdExec;
        }

        public String getScript() {
            return ((AutomatedExecutionExtender)this.paramdExec.getA1()).getAutomatedTest().getName();
        }

        public String getId() {
            return ((AutomatedExecutionExtender)this.paramdExec.getA1()).getId().toString();
        }

        public Map<String, Object> getParam() {
            return (Map)this.paramdExec.getA2();
        }
    }
}

