/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.BuildStage;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.JsonParser;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.HttpRequestFactory;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.BuildProcessor;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.BuildAbsoluteId;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.CheckBuildQueue;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.CheckBuildRunning;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.GatherTestList;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.GetBuildID;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.HttpBasedStep;

public abstract class HttpBasedStepSequence {
    protected HttpRequestFactory requestFactory = new HttpRequestFactory();
    protected JsonParser jsonParser = new JsonParser();
    protected BuildStage currentStage = BuildStage.WAITING;
    protected HttpClient client;
    protected TestAutomationProject project;
    protected BuildAbsoluteId absoluteId;

    void setClient(HttpClient client) {
        this.client = client;
    }

    void setProject(TestAutomationProject project) {
        this.project = project;
    }

    void setAbsoluteId(BuildAbsoluteId absoluteId) {
        this.absoluteId = absoluteId;
    }

    protected abstract BuildProcessor getProcessor();

    protected CheckBuildQueue newCheckQueue() {
        GetMethod method = this.requestFactory.newCheckQueue(this.project);
        CheckBuildQueue checkQueue = new CheckBuildQueue(this.getProcessor());
        this.wireHttpSteps(checkQueue, (HttpMethod)method);
        return checkQueue;
    }

    protected GetBuildID newGetBuildID() {
        GetMethod method = this.requestFactory.newGetBuildsForProject(this.project);
        GetBuildID getBuildID = new GetBuildID(this.getProcessor());
        this.wireHttpSteps(getBuildID, (HttpMethod)method);
        return getBuildID;
    }

    protected CheckBuildRunning newCheckBuildRunning() {
        GetMethod method = this.requestFactory.newGetBuild(this.project, this.absoluteId.getBuildId());
        CheckBuildRunning running = new CheckBuildRunning(this.getProcessor());
        this.wireHttpSteps(running, (HttpMethod)method);
        return running;
    }

    protected GatherTestList newGatherTestList() {
        GetMethod method = this.requestFactory.newGetJsonTestList(this.project);
        GatherTestList gatherList = new GatherTestList(this.getProcessor());
        this.wireHttpSteps(gatherList, (HttpMethod)method);
        return gatherList;
    }

    protected void wireHttpSteps(HttpBasedStep step, HttpMethod method) {
        step.setClient(this.client);
        step.setMethod(method);
        step.setParser(this.jsonParser);
        step.setBuildAbsoluteId(this.absoluteId);
    }
}

