/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal.net;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.domain.testautomation.AutomatedTest;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.FileParameter;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.Parameter;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.ParameterArray;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.JsonParser;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.CallbackURL;
import org.squashtest.tm.service.testautomation.spi.BadConfiguration;
import org.squashtest.tm.service.testautomation.spi.TestAutomationException;

public class HttpRequestFactory {
    private static final String JOB_PATH = "/job/";
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequestFactory.class);
    private static final String API_URI = "/api/json";
    private static final String TREE = "tree";
    public static final String SYMBOLIC_BUILDFILENAME = "testsuite.json";
    public static final String MULTIPART_BUILDFILENAME = "file0";
    public static final String MULTIPART_JENKINSARGS = "json";
    private static final NameValuePair[] JOB_LIST_QUERY = new NameValuePair[]{new NameValuePair("tree", "jobs[name,color]")};
    private static final NameValuePair[] QUEUED_BUILDS_QUERY = new NameValuePair[]{new NameValuePair("tree", "items[id,actions[parameters[name,value]],task[name]]")};
    private static final NameValuePair[] EXISTING_BUILDS_QUERY = new NameValuePair[]{new NameValuePair("tree", "builds[building,number,actions[parameters[name,value]]]")};
    private static final NameValuePair[] SINGLE_BUILD_QUERY = new NameValuePair[]{new NameValuePair("tree", "building,number,actions[parameters[name,value]]")};
    private static final NameValuePair[] BUILD_RESULT_QUERY = new NameValuePair[]{new NameValuePair("tree", "suites[name,cases[name,status]]")};
    private JsonParser jsonParser = new JsonParser();
    private CallbackURLProvider callbackProvider = new CallbackURLProvider();

    public String newRandomId() {
        return Long.valueOf(System.currentTimeMillis()).toString();
    }

    public GetMethod newCheckCredentialsMethod(TestAutomationServer server) {
        String path = this.toUrlPath(server, API_URI);
        GetMethod method = new GetMethod();
        method.setPath(path);
        String logPass = String.valueOf(server.getLogin()) + ":" + server.getPassword();
        String auth = new String(Base64.encodeBase64((byte[])logPass.getBytes()));
        method.addRequestHeader(new Header("Authorization", "Basic " + auth));
        method.setDoAuthentication(true);
        return method;
    }

    public GetMethod newGetJobsMethod(TestAutomationServer server) {
        String path = this.toUrlPath(server, API_URI);
        GetMethod method = new GetMethod();
        method.setPath(path);
        method.setQueryString(JOB_LIST_QUERY);
        method.setDoAuthentication(true);
        return method;
    }

    public PostMethod newStartFetchTestListBuild(TestAutomationProject project, String externalID) {
        ParameterArray params = new ParameterArray(new Parameter[]{Parameter.operationTestListParameter(), Parameter.newExtIdParameter(externalID)});
        PostMethod method = this.newStartBuild(project, params);
        return method;
    }

    public ParameterArray getStartTestSuiteBuildParameters(String externalID) {
        String strURL = this.callbackProvider.get().toExternalForm();
        return new ParameterArray(new Object[]{Parameter.operationRunSuiteParameter(), Parameter.newExtIdParameter(externalID), Parameter.newCallbackURlParameter(strURL), Parameter.testListParameter(), new FileParameter(SYMBOLIC_BUILDFILENAME, MULTIPART_BUILDFILENAME)});
    }

    public ParameterArray getStartTestSuiteBuildParameters(String externalID, String executor) {
        String strURL = this.callbackProvider.get().toExternalForm();
        if (StringUtils.isBlank((String)executor)) {
            return this.getStartTestSuiteBuildParameters(externalID);
        }
        return new ParameterArray(new Object[]{Parameter.operationRunSuiteParameter(), Parameter.newExtIdParameter(externalID), Parameter.newCallbackURlParameter(strURL), Parameter.testListParameter(), Parameter.executorParameter(executor), new FileParameter(SYMBOLIC_BUILDFILENAME, MULTIPART_BUILDFILENAME)});
    }

    public GetMethod newCheckQueue(TestAutomationProject project) {
        String path = this.toUrlPath(project.getServer(), "/queue/api/json");
        GetMethod method = new GetMethod();
        method.setPath(path);
        method.setQueryString(QUEUED_BUILDS_QUERY);
        method.setDoAuthentication(true);
        return method;
    }

    public GetMethod newGetBuildsForProject(TestAutomationProject project) {
        String path = this.toUrlPath(project.getServer(), JOB_PATH + project.getJobName() + API_URI);
        GetMethod method = new GetMethod();
        method.setPath(path);
        method.setQueryString(EXISTING_BUILDS_QUERY);
        method.setDoAuthentication(true);
        return method;
    }

    public GetMethod newGetBuild(TestAutomationProject project, int buildId) {
        String path = this.toUrlPath(project.getServer(), JOB_PATH + project.getJobName() + "/" + buildId + "/" + API_URI);
        GetMethod method = new GetMethod();
        method.setPath(path);
        method.setQueryString(SINGLE_BUILD_QUERY);
        method.setDoAuthentication(true);
        return method;
    }

    public GetMethod newGetBuildResults(TestAutomationProject project, int buildId) {
        String path = this.toUrlPath(project.getServer(), JOB_PATH + project.getJobName() + "/" + buildId + "/testReport/" + API_URI);
        GetMethod method = new GetMethod();
        method.setPath(path);
        method.setQueryString(BUILD_RESULT_QUERY);
        method.setDoAuthentication(true);
        return method;
    }

    public GetMethod newGetJsonTestList(TestAutomationProject project) {
        String path = this.toUrlPath(project.getServer(), JOB_PATH + project.getJobName() + "/Test_list/testTree.json");
        GetMethod method = new GetMethod();
        method.setPath(path);
        method.setDoAuthentication(true);
        return method;
    }

    public String buildResultURL(AutomatedTest test, Integer buildID) {
        TestAutomationProject project = test.getProject();
        String relativePath = this.toRelativePath(test);
        String urlPath = this.toUrlPath(project.getServer(), JOB_PATH + project.getJobName() + "/" + buildID + "/testReport/" + relativePath);
        return urlPath;
    }

    protected PostMethod newStartBuild(TestAutomationProject project, ParameterArray params) {
        String path = this.toUrlPath(project.getServer(), JOB_PATH + project.getJobName() + "/build");
        String jsonParam = this.jsonParser.toJson(params);
        PostMethod method = new PostMethod();
        method.setPath(path);
        method.setParameter(MULTIPART_JENKINSARGS, jsonParam);
        method.setDoAuthentication(true);
        return method;
    }

    private String toUrlPath(TestAutomationServer server, String path) {
        StringBuilder urlBuilder = new StringBuilder();
        URL baseURL = server.getBaseURL();
        urlBuilder.append(baseURL.toExternalForm());
        urlBuilder.append(path);
        return this.makeURL(urlBuilder.toString()).toExternalForm();
    }

    private URL makeURL(String unescaped) {
        try {
            String uri = URIUtil.encodePath((String)unescaped);
            return new URL(uri);
        }
        catch (URIException ex) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("HttpRequestFactory : the URI is invalid, and that was not supposed to happen.");
            }
            throw new TestAutomationException((Throwable)ex);
        }
        catch (MalformedURLException ex) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("HttpRequestFactory : the URI corresponds to an invalid URL, and that was not supposed to happen.");
            }
            throw new TestAutomationException((Throwable)ex);
        }
    }

    private String toRelativePath(AutomatedTest test) {
        String name = "";
        if (test.isAtTheRoot()) {
            name = "(root)/";
        }
        name = String.valueOf(name) + test.getPath() + test.getShortName().replaceAll("[-\\.]", "_");
        return name;
    }

    private static class CallbackURLProvider {
        private CallbackURLProvider() {
        }

        public URL get() {
            CallbackURL callback = CallbackURL.getInstance();
            String strURL = callback.getValue();
            try {
                return new URL(strURL);
            }
            catch (MalformedURLException ex) {
                BadConfiguration bc = new BadConfiguration("Test Automation configuration : The test could not be started because the service is not configured properly. The url '" + strURL + "' specified at property '" + callback.getConfPropertyName() + "' in configuration file 'tm.testautomation.conf.properties' is malformed. Please contact the administration team.", (Throwable)ex);
                bc.setPropertyName(callback.getConfPropertyName());
                throw bc;
            }
        }
    }
}

