/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal.net;

import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.CommonsClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;

@Component
public class HttpClientProvider {
    private Set<ServerKey> knownServers = new HashSet<ServerKey>();
    private final HttpClient client;
    private final ClientHttpRequestFactory requestFactory;

    public HttpClientProvider() {
        MultiThreadedHttpConnectionManager manager = new MultiThreadedHttpConnectionManager();
        manager.getParams().setMaxTotalConnections(25);
        this.client = new HttpClient((HttpConnectionManager)manager);
        this.client.getParams().setAuthenticationPreemptive(true);
        this.requestFactory = new CommonsClientHttpRequestFactory(this.client);
    }

    public HttpClient getClientFor(TestAutomationServer server) {
        ServerKey key = new ServerKey(server);
        if (!this.knownServers.contains(key)) {
            this.registerServer(server);
        }
        return this.client;
    }

    public ClientHttpRequestFactory getRequestFactoryFor(TestAutomationServer server) {
        this.getClientFor(server);
        return this.requestFactory;
    }

    protected void registerServer(TestAutomationServer server) {
        URL baseURL = server.getBaseURL();
        AuthScope authscope = new AuthScope(baseURL.getHost(), baseURL.getPort(), AuthScope.ANY_REALM);
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(server.getLogin(), server.getPassword());
        this.client.getState().setCredentials(authscope, (Credentials)creds);
    }

    private static class ServerKey {
        private String serverURL;
        private String serverLogin;
        private String serverPass;
        private String serverKind;

        public ServerKey(TestAutomationServer server) {
            this.serverURL = server.getBaseURL().toExternalForm();
            this.serverLogin = server.getLogin();
            this.serverPass = server.getPassword();
            this.serverKind = server.getKind();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.serverKind == null ? 0 : this.serverKind.hashCode());
            result = 31 * result + (this.serverLogin == null ? 0 : this.serverLogin.hashCode());
            result = 31 * result + (this.serverPass == null ? 0 : this.serverPass.hashCode());
            result = 31 * result + (this.serverURL == null ? 0 : this.serverURL.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ServerKey other = (ServerKey)obj;
            if (this.serverKind == null ? other.serverKind != null : !this.serverKind.equals(other.serverKind)) {
                return false;
            }
            if (this.serverLogin == null ? other.serverLogin != null : !this.serverLogin.equals(other.serverLogin)) {
                return false;
            }
            if (this.serverPass == null ? other.serverPass != null : !this.serverPass.equals(other.serverPass)) {
                return false;
            }
            return !(this.serverURL == null ? other.serverURL != null : !this.serverURL.equals(other.serverURL));
        }
    }
}

