/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.std.query;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.squashtest.tm.api.report.criteria.Criteria;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.internal.domain.report.query.jpa.AbstractJpaReportQuery;
import org.squashtest.tm.internal.domain.report.query.jpa.JpaExecutionProgressQuery;
import org.squashtest.tm.plugin.report.std.query.AbstractJpaQueryAdapter;

public class ExecutionProgressQueryAdapter
extends AbstractJpaQueryAdapter<Campaign, JpaExecutionProgressQuery> {
    static final String CAMPAIGN_IDS = "campaignIds";
    static final String LEGACY_CAMPAIGN_IDS = "campaignIds[]";
    static final String CAMPAIGN_SELECTION_MODE = "campaignSelectionMode";
    static final String MILESTONE_IDS = "milestones";
    @Inject
    private Provider<JpaExecutionProgressQuery> legacyQueryProvider;

    @Override
    protected void processNonStandardCriteria(Map<String, Criteria> criteria, AbstractJpaReportQuery<Campaign> legacyQuery) {
        Criteria selMode = criteria.get(CAMPAIGN_SELECTION_MODE);
        if ("EVERYTHING".equals(selMode.getValue())) {
            legacyQuery.setCriterion(LEGACY_CAMPAIGN_IDS, null);
        } else if ("MILESTONE_PICKER".equals(selMode.getValue())) {
            Criteria mIdsCrit = criteria.get(MILESTONE_IDS);
            Collection values = (Collection)mIdsCrit.getValue();
            legacyQuery.setCriterion(MILESTONE_IDS, values.toArray());
        } else {
            Criteria idsCrit = criteria.get(CAMPAIGN_IDS);
            HashSet nodesIds = new HashSet();
            this.addCampaignIds(idsCrit, nodesIds, "campaigns");
            this.addCampaignIds(idsCrit, nodesIds, "campaign-folders");
            legacyQuery.setCriterion(LEGACY_CAMPAIGN_IDS, nodesIds.toArray());
        }
    }

    private void addCampaignIds(Criteria idsCrit, Collection nodesIds, String nodeType) {
        Collection campaignIds = (Collection)((Map)idsCrit.getValue()).get(nodeType);
        if (campaignIds != null) {
            nodesIds.addAll(campaignIds);
        }
    }

    @Override
    protected boolean isStandardCriteria(String criterionName) {
        return switch (criterionName) {
            case CAMPAIGN_SELECTION_MODE, MILESTONE_IDS, CAMPAIGN_IDS -> false;
            default -> true;
        };
    }

    @Override
    protected Provider<JpaExecutionProgressQuery> getLegacyQueryProvider() {
        return this.legacyQueryProvider;
    }
}

