/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.std.query;

import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.squashtest.tm.api.report.criteria.Criteria;
import org.squashtest.tm.api.report.query.ReportQuery;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.internal.domain.report.query.jpa.AbstractJpaReportQuery;
import org.squashtest.tm.plugin.report.std.service.ReportService;
import org.squashtest.tm.service.milestone.MilestoneFinderService;

public abstract class AbstractJpaQueryAdapter<T, QUERY extends AbstractJpaReportQuery<T>>
implements ReportQuery {
    @Inject
    private ReportService reportService;
    @Inject
    private MilestoneFinderService milestoneFinderService;

    protected AbstractJpaQueryAdapter() {
    }

    public final void executeQuery(Map<String, Criteria> criteria, Map<String, Object> model) {
        AbstractJpaReportQuery jpaReportQuery = (AbstractJpaReportQuery)this.getLegacyQueryProvider().get();
        this.processNonStandardCriteria(criteria, jpaReportQuery);
        this.processStandardCriteria(criteria, jpaReportQuery);
        List<Object> data = this.reportService.executeQuery(jpaReportQuery);
        model.put("data", data);
        Criteria selectionMode = criteria.get("campaignSelectionMode");
        if (selectionMode != null && "MILESTONE_PICKER".equals(selectionMode.getValue())) {
            List milestoneIds = (List)criteria.get("milestones").getValue();
            Milestone milestone = this.milestoneFinderService.findById(((Integer)milestoneIds.get(0)).longValue());
            model.put("milestoneLabel", milestone.getLabel());
        }
    }

    protected abstract void processNonStandardCriteria(Map<String, Criteria> var1, AbstractJpaReportQuery<T> var2);

    private void processStandardCriteria(Map<String, Criteria> criteria, AbstractJpaReportQuery<T> jpaReportQuery) {
        for (Map.Entry<String, Criteria> entry : criteria.entrySet()) {
            if (!this.isStandardCriteria(entry.getKey())) continue;
            jpaReportQuery.setCriterion(entry.getKey(), entry.getValue().getValue());
        }
    }

    protected abstract boolean isStandardCriteria(String var1);

    protected abstract Provider<QUERY> getLegacyQueryProvider();
}

