/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.internal.domain.report.query.jpa;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.internal.domain.report.common.dto.ExProgressCampaignDto;
import org.squashtest.tm.internal.domain.report.common.dto.ExProgressIterationDto;
import org.squashtest.tm.internal.domain.report.common.dto.ExProgressProjectDto;
import org.squashtest.tm.internal.domain.report.common.dto.ExProgressTestPlanDto;
import org.squashtest.tm.internal.domain.report.common.jpa.AboveDateJpaCriterion;
import org.squashtest.tm.internal.domain.report.common.jpa.AbstractIsInSetJpaCriterion;
import org.squashtest.tm.internal.domain.report.common.jpa.BelowDateJpaCriterion;
import org.squashtest.tm.internal.domain.report.common.jpa.CampaignBelongToMilestoneJpaCriterion;
import org.squashtest.tm.internal.domain.report.common.jpa.IsRunningCampaignJpaCriterion;
import org.squashtest.tm.internal.domain.report.query.jpa.AbstractJpaReportCriterion;
import org.squashtest.tm.internal.domain.report.query.jpa.AbstractJpaReportQuery;

public class JpaExecutionProgressQuery
extends AbstractJpaReportQuery<Campaign> {
    private static final String CRIT_NAME_MILESTONE = "milestones";

    public JpaExecutionProgressQuery() {
        this.criteriaByName.put("scheduledStart", new AboveDateJpaCriterion("scheduledPeriod.scheduledStartDate"));
        this.criteriaByName.put("actualStart", new AboveDateJpaCriterion("actualPeriod.actualStartDate"));
        this.criteriaByName.put("scheduledEnd", new BelowDateJpaCriterion("scheduledPeriod.scheduledEndDate"));
        this.criteriaByName.put("actualEnd", new BelowDateJpaCriterion("actualPeriod.actualEndDate"));
        this.criteriaByName.put("campaignStatus", new IsRunningCampaignJpaCriterion());
        this.criteriaByName.put("campaignIds[]", new CampaignIdIsInIds());
        this.criteriaByName.put(CRIT_NAME_MILESTONE, new CampaignBelongToMilestoneJpaCriterion());
    }

    @Override
    public boolean isCriteriaQueryBased() {
        return true;
    }

    @Override
    protected Class<Campaign> getEntityType() {
        return Campaign.class;
    }

    @Override
    public <R, D> List<D> convertToDto(List<R> rawData) {
        List<Campaign> unfilteredList = rawData;
        List<Campaign> campaignList = this.filterUnwantedDataOut(unfilteredList);
        String milestone = this.findMilestoneLabel(campaignList);
        HashMap<Long, ExProgressProjectDto> projectMap = new HashMap<Long, ExProgressProjectDto>();
        for (Campaign campaign : campaignList) {
            Project project = campaign.getProject();
            if (projectMap.containsKey(project.getId())) continue;
            ExProgressProjectDto projectDto = new ExProgressProjectDto();
            projectDto.setName(project.getName());
            projectDto.setId(project.getId());
            projectDto.setAllowsSettled(project.getCampaignLibrary().allowsStatus(ExecutionStatus.SETTLED));
            projectDto.setAllowsUntestable(project.getCampaignLibrary().allowsStatus(ExecutionStatus.UNTESTABLE));
            if (milestone != null) {
                projectDto.setMilestone(milestone);
            }
            projectMap.put(project.getId(), projectDto);
        }
        for (Campaign campaign : campaignList) {
            ExProgressCampaignDto campDto = this.makeCampaignDto(campaign);
            Project project = campaign.getProject();
            ExProgressProjectDto projectDto = (ExProgressProjectDto)projectMap.get(project.getId());
            campDto.setProject(projectDto);
            projectDto.addCampaignDto(campDto);
        }
        this.fillProjectStatusInfos(projectMap);
        LinkedList projectList = new LinkedList(projectMap.values());
        if (projectList.isEmpty()) {
            projectList.add(new ExProgressProjectDto());
        }
        return projectList;
    }

    private void fillProjectStatusInfos(Map<Long, ExProgressProjectDto> projectMap) {
        for (Map.Entry<Long, ExProgressProjectDto> entry : projectMap.entrySet()) {
            ExProgressProjectDto projectDto = entry.getValue();
            projectDto.fillStatusInfosWithChildren(projectDto.getCampaigns());
        }
    }

    protected List<Campaign> filterUnwantedDataOut(List<Campaign> list) {
        LinkedList<Campaign> toReturn = new LinkedList<Campaign>();
        for (Campaign campaign : list) {
            if (!this.getDataFilteringService().isFullyAllowed(campaign)) continue;
            toReturn.add(campaign);
        }
        return toReturn;
    }

    private ExProgressCampaignDto makeCampaignDto(Campaign campaign) {
        ExProgressCampaignDto campDto = new ExProgressCampaignDto().fillBasicInfos(campaign);
        for (Iteration iteration : campaign.getIterations()) {
            ExProgressIterationDto iterDto = this.makeIterationDto(iteration);
            campDto.addIterationDto(iterDto);
            iterDto.setCampaign(campDto);
        }
        campDto.fillStatusInfosWithChildren(campDto.getIterations());
        return campDto;
    }

    private ExProgressIterationDto makeIterationDto(Iteration iteration) {
        ExProgressIterationDto iterDto = new ExProgressIterationDto(iteration);
        for (IterationTestPlanItem testPlan : iteration.getTestPlans()) {
            ExProgressTestPlanDto testPlanDto = this.makeTestPlanDto(testPlan);
            iterDto.addTestPlanDto(testPlanDto);
            testPlanDto.setIteration(iterDto);
        }
        return iterDto;
    }

    private ExProgressTestPlanDto makeTestPlanDto(IterationTestPlanItem testPlan) {
        return new ExProgressTestPlanDto().fillBasicInfo(testPlan);
    }

    private String findMilestoneLabel(List<Campaign> campaignList) {
        AbstractJpaReportCriterion milestoneCrit = (AbstractJpaReportCriterion)this.criteriaByName.get(CRIT_NAME_MILESTONE);
        if (milestoneCrit != null) {
            Object[] ids = milestoneCrit.getParameters();
            return this.findMilestoneLabelFromCriteria(ids, campaignList);
        }
        return null;
    }

    private String findMilestoneLabelFromCriteria(Object[] ids, List<Campaign> campaignList) {
        if (ids != null && ids.length > 0 && !campaignList.isEmpty()) {
            Long milestoneId = Long.valueOf(ids[0].toString());
            Campaign c = campaignList.get(0);
            for (Milestone m : c.getMilestones()) {
                if (!m.getId().equals(milestoneId)) continue;
                return m.getLabel();
            }
        }
        return null;
    }

    private static class CampaignIdIsInIds
    extends AbstractIsInSetJpaCriterion<Long> {
        public CampaignIdIsInIds() {
            super("id");
        }

        @Override
        public Long fromValueToTypedValue(Object o) {
            return Long.parseLong(o.toString());
        }
    }
}

