/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.internal.domain.report.common.jpa;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.internal.domain.report.common.dto.ExProgressCampaignStatus;
import org.squashtest.tm.internal.domain.report.query.jpa.AbstractJpaReportCriterion;

public class IsRunningCampaignJpaCriterion
extends AbstractJpaReportCriterion {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsRunningCampaignJpaCriterion.class);

    @Override
    public <X> Predicate makePredicate(CriteriaBuilder cb, Root<X> root) {
        try {
            Object[] values = this.getParameters();
            if (values != null && values.length > 0) {
                ExProgressCampaignStatus status = ExProgressCampaignStatus.valueOf(values[0].toString());
                CriteriaQuery cq = cb.createQuery(Long.class);
                Subquery subquery = cq.subquery(Long.class);
                Root subRoot = subquery.from(Campaign.class);
                subquery.select((Expression)subRoot.get("id"));
                subquery.where((Expression)cb.or((Expression)cb.equal((Expression)subRoot.join("iterations").join("testPlans").get("executionStatus"), (Object)ExecutionStatus.READY), (Expression)cb.equal((Expression)subRoot.join("iterations").join("testPlans").get("executionStatus"), (Object)ExecutionStatus.RUNNING)));
                if (status == ExProgressCampaignStatus.CAMPAIGN_RUNNING) {
                    return cb.in((Expression)root.get("id")).value((Expression)subquery);
                }
                if (status == ExProgressCampaignStatus.CAMPAIGN_OVER) {
                    return cb.not((Expression)cb.in((Expression)root.get("id")).value((Expression)subquery));
                }
                return this.noopPredicate(cb);
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.error("Error while building criterion, defaulting to no-op predicate.", (Throwable)e);
            return this.noopPredicate(cb);
        }
    }
}

