/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.internal.domain.report.common.jpa;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.internal.domain.report.query.jpa.AbstractJpaReportCriterion;

public class AboveDateJpaCriterion
extends AbstractJpaReportCriterion {
    private static final Logger LOGGER = LoggerFactory.getLogger(AboveDateJpaCriterion.class);
    private final String attributePath;

    public AboveDateJpaCriterion(String attributePath) {
        this.attributePath = attributePath;
    }

    private Date makeDate() throws IllegalArgumentException {
        Date date = (Date)this.requireUniqueParameter();
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    @Override
    public <X> Predicate makePredicate(CriteriaBuilder cb, Root<X> root) {
        try {
            Date arg = this.makeDate();
            return cb.greaterThan((Expression)root.get(this.attributePath), (Comparable)arg);
        }
        catch (ClassCastException | IllegalArgumentException e) {
            LOGGER.error("Error while building criterion, defaulting to no-op predicate.", (Throwable)e);
            return this.noopPredicate(cb);
        }
    }
}

