/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.internal.domain.report.common.hibernate;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.internal.domain.report.common.dto.ExProgressCampaignDto;
import org.squashtest.tm.internal.domain.report.common.dto.ExProgressIterationDto;
import org.squashtest.tm.internal.domain.report.common.dto.ExProgressProjectDto;
import org.squashtest.tm.internal.domain.report.common.dto.ExProgressTestPlanDto;
import org.squashtest.tm.internal.domain.report.common.hibernate.AboveDateCriterion;
import org.squashtest.tm.internal.domain.report.common.hibernate.BelowDateCriterion;
import org.squashtest.tm.internal.domain.report.common.hibernate.CampaignBelongToMilestone;
import org.squashtest.tm.internal.domain.report.common.hibernate.IsInSet;
import org.squashtest.tm.internal.domain.report.common.hibernate.IsRunningCampaignCriterion;
import org.squashtest.tm.internal.domain.report.query.hibernate.HibernateReportQuery;
import org.squashtest.tm.internal.domain.report.query.hibernate.ReportCriterion;

public class HibernateExecutionProgressQuery
extends HibernateReportQuery {
    private static final String CRIT_NAME_MILESTONE = "milestones";

    public HibernateExecutionProgressQuery() {
        Map<String, ReportCriterion> criterions = this.getCriterions();
        AboveDateCriterion schedStartDate = new AboveDateCriterion("scheduledStart", "scheduledPeriod.scheduledStartDate");
        criterions.put("scheduledStart", schedStartDate);
        AboveDateCriterion actualStartDate = new AboveDateCriterion("actualStart", "actualPeriod.actualStartDate");
        criterions.put("actualStart", actualStartDate);
        BelowDateCriterion schedEndDate = new BelowDateCriterion("scheduledEnd", "scheduledPeriod.scheduledEndDate");
        criterions.put("scheduledEnd", schedEndDate);
        BelowDateCriterion actualEndDate = new BelowDateCriterion("actualEnd", "actualPeriod.actualEndDate");
        criterions.put("actualEnd", actualEndDate);
        IsRunningCampaignCriterion campaignStatus = new IsRunningCampaignCriterion();
        campaignStatus.setCriterionName("campaignStatus");
        criterions.put("campaignStatus", campaignStatus);
        CampaignIdIsInIds campaignIds = new CampaignIdIsInIds("campaignIds[]", "id", Campaign.class, "campaigns"){};
        criterions.put("campaignIds[]", campaignIds);
        CampaignBelongToMilestone milestones = new CampaignBelongToMilestone();
        criterions.put(CRIT_NAME_MILESTONE, milestones);
    }

    @Override
    public DetachedCriteria createHibernateQuery() {
        DetachedCriteria criteria = DetachedCriteria.forClass(Campaign.class, (String)"campaigns");
        Collection<String> params = this.getCriterionNames();
        for (String name : params) {
            criteria = this.addCriterion(criteria, name);
        }
        criteria.addOrder(Order.asc((String)"campaigns.name"));
        return criteria;
    }

    @Override
    public List<?> doInSession(Session session) {
        return Collections.emptyList();
    }

    @Override
    public List<?> convertToDto(List<?> rawData) {
        List<Campaign> unfilteredList = rawData;
        List<Campaign> campaignList = this.filterUnwantedDataOut(unfilteredList);
        String milestone = this.findMilestoneLabel(campaignList);
        HashMap<Long, ExProgressProjectDto> projectMap = new HashMap<Long, ExProgressProjectDto>();
        for (Campaign campaign : campaignList) {
            Project project = campaign.getProject();
            if (projectMap.keySet().contains(project.getId())) continue;
            ExProgressProjectDto projectDto = new ExProgressProjectDto();
            projectDto.setName(project.getName());
            projectDto.setId(project.getId());
            projectDto.setAllowsSettled(project.getCampaignLibrary().allowsStatus(ExecutionStatus.SETTLED));
            projectDto.setAllowsUntestable(project.getCampaignLibrary().allowsStatus(ExecutionStatus.UNTESTABLE));
            if (milestone != null) {
                projectDto.setMilestone(milestone);
            }
            projectMap.put(project.getId(), projectDto);
        }
        for (Campaign campaign : campaignList) {
            ExProgressCampaignDto campDto = this.makeCampaignDto(campaign);
            Project project = campaign.getProject();
            ExProgressProjectDto projectDto = (ExProgressProjectDto)projectMap.get(project.getId());
            campDto.setProject(projectDto);
            projectDto.addCampaignDto(campDto);
        }
        LinkedList<Object> projectList = new LinkedList<Object>();
        this.fillProjectStatusInfos(projectMap);
        projectList.addAll(projectMap.values());
        if (projectList.isEmpty()) {
            projectList.add(new ExProgressProjectDto());
        }
        return projectList;
    }

    private void fillProjectStatusInfos(Map<Long, ExProgressProjectDto> projectMap) {
        for (Map.Entry<Long, ExProgressProjectDto> entry : projectMap.entrySet()) {
            ExProgressProjectDto projectDto = entry.getValue();
            projectDto.fillStatusInfosWithChildren(projectDto.getCampaigns());
        }
    }

    protected List<Campaign> filterUnwantedDataOut(List<Campaign> list) {
        LinkedList<Campaign> toReturn = new LinkedList<Campaign>();
        for (Campaign campaign : list) {
            if (!this.getDataFilteringService().isFullyAllowed(campaign)) continue;
            toReturn.add(campaign);
        }
        return toReturn;
    }

    private ExProgressCampaignDto makeCampaignDto(Campaign campaign) {
        ExProgressCampaignDto campDto = new ExProgressCampaignDto().fillBasicInfos(campaign);
        for (Iteration iteration : campaign.getIterations()) {
            ExProgressIterationDto iterDto = this.makeIterationDto(iteration);
            campDto.addIterationDto(iterDto);
            iterDto.setCampaign(campDto);
        }
        campDto.fillStatusInfosWithChildren(campDto.getIterations());
        return campDto;
    }

    private ExProgressIterationDto makeIterationDto(Iteration iteration) {
        ExProgressIterationDto iterDto = new ExProgressIterationDto(iteration);
        for (IterationTestPlanItem testPlan : iteration.getTestPlans()) {
            ExProgressTestPlanDto testPlanDto = this.makeTestPlanDto(testPlan);
            iterDto.addTestPlanDto(testPlanDto);
            testPlanDto.setIteration(iterDto);
        }
        return iterDto;
    }

    private ExProgressTestPlanDto makeTestPlanDto(IterationTestPlanItem testPlan) {
        return new ExProgressTestPlanDto().fillBasicInfo(testPlan);
    }

    private String findMilestoneLabel(List<Campaign> campaignList) {
        ReportCriterion milestoneCrit = (ReportCriterion)this.criterions.get(CRIT_NAME_MILESTONE);
        if (milestoneCrit != null) {
            Object[] ids = milestoneCrit.getParameters();
            return this.findMilestoneLabelFromCriteria(ids, campaignList);
        }
        return null;
    }

    private String findMilestoneLabelFromCriteria(Object[] ids, List<Campaign> campaignList) {
        if (ids != null && ids.length > 0 && !campaignList.isEmpty()) {
            Long milestoneId = Long.valueOf(ids[0].toString());
            Campaign c = campaignList.get(0);
            for (Milestone m : c.getMilestones()) {
                if (!m.getId().equals(milestoneId)) continue;
                return m.getLabel();
            }
        }
        return null;
    }

    private static class CampaignIdIsInIds
    extends IsInSet<Long> {
        public CampaignIdIsInIds(String criterionName, String attributePath, Class<?> entityClass, String entityAlias) {
            super(criterionName, attributePath, entityClass, entityAlias);
        }

        @Override
        public Long fromValueToTypedValue(Object o) {
            return Long.parseLong(o.toString());
        }
    }
}

