/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.internal.service;

import javax.inject.Inject;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.project.ProjectResource;
import org.squashtest.tm.domain.projectfilter.ProjectFilter;
import org.squashtest.tm.plugin.report.std.service.DataFilteringService;
import org.squashtest.tm.service.project.ProjectFilterModificationService;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service(value="squashtest.tm.service.DataFilteringService")
@Transactional(readOnly=true)
public class DataFilteringServiceImpl
implements DataFilteringService {
    @Inject
    private PermissionEvaluationService permissionService;
    @Inject
    private ProjectFilterModificationService userFilterService;

    @Override
    public boolean isFullyAllowed(Object object) {
        return this.hasReadPermissions(object) && (!this.isInstanceOfProjectResource(object) || this.isAllowedByUser((ProjectResource)object));
    }

    private boolean isInstanceOfProjectResource(Object object) {
        return object instanceof ProjectResource;
    }

    @Override
    public boolean hasReadPermissions(Object object) {
        return this.permissionService.canRead(object);
    }

    @Override
    public boolean isAllowedByUser(ProjectResource object) {
        ProjectFilter filter = this.userFilterService.findProjectFilterByUserLogin();
        return filter.getActivated() == false || filter.isProjectSelected(object.getProject());
    }
}

