/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.internal.domain.report.common.hibernate;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.query.Query;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.internal.domain.report.common.dto.ReqCoverageByTestProjectDto;
import org.squashtest.tm.internal.domain.report.common.dto.ReqCoverageByTestRequirementSingleDto;
import org.squashtest.tm.internal.domain.report.common.dto.ReqCoverageByTestStatType;
import org.squashtest.tm.internal.domain.report.common.hibernate.IsInSet;
import org.squashtest.tm.internal.domain.report.common.hibernate.RequirementReportTypeCriterion;
import org.squashtest.tm.internal.domain.report.query.hibernate.HibernateReportQuery;
import org.squashtest.tm.internal.domain.report.query.hibernate.ReportCriterion;

public class HibernateRequirementCoverageByTestsQuery
extends HibernateReportQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(HibernateRequirementCoverageByTestsQuery.class);
    private static final double DEFAULT_RATE_VALUE = 100.0;
    private static final String TOTAL_PROJECT_NAME = "TOTAL";
    private static final int REPORT_VERSION_BOUND_TO_MILESTONE = 0;
    private static final int REPORT_EACH_VERSION = 1;
    private static final int REPORT_LAST_VERSION = 2;
    private static final String PROJECT_IDS = "projectIds[]";
    private static final String MILESTONE_IDS = "milestones";
    private static final String FIND_REQUIREMENT_PARENT_NAMES = "select rlnc.descendant_id, res.name from RLN_RELATIONSHIP rlnc  inner join REQUIREMENT_FOLDER rf on rlnc.ancestor_id = rf.rln_id  inner join RESOURCE res on rf.res_id = res.res_id where rlnc.descendant_id in (:reqIds) UNION select rlnc.descendant_id, res.name from RLN_RELATIONSHIP rlnc  inner join REQUIREMENT r on rlnc.ancestor_id = r.rln_id  inner join RESOURCE res on r.current_version_id = res.res_id where rlnc.descendant_id in (:reqIds) UNION select req.rln_id, '-' from REQUIREMENT req  left join RLN_RELATIONSHIP rlnc on req.rln_id = rlnc.descendant_id where rlnc.descendant_id is null and req.rln_id in (:reqIds) ";

    public HibernateRequirementCoverageByTestsQuery() {
        Map<String, ReportCriterion> criterions = this.getCriterions();
        ProjectIdsIsInIds projectIds = new ProjectIdsIsInIds(PROJECT_IDS, "id", Project.class, "projects");
        criterions.put(PROJECT_IDS, projectIds);
        MilestoneIdsIsInIds milestoneIds = new MilestoneIdsIsInIds(MILESTONE_IDS, "id", Milestone.class, MILESTONE_IDS);
        criterions.put(MILESTONE_IDS, milestoneIds);
        RequirementReportTypeCriterion reportMode = new RequirementReportTypeCriterion("mode", "on s'en fout");
        criterions.put("mode", reportMode);
    }

    @Override
    public DetachedCriteria createHibernateQuery() {
        return null;
    }

    @Override
    public List<?> doInSession(Session session) {
        List<Long> ids = this.findRequirementIds(session);
        List<Requirement> requirements = this.findRequirements(session, ids);
        List<Object[]> parentsNameOfRequirements = this.findParentsNames(session, ids);
        return this.pairRequirementAndParents(requirements, parentsNameOfRequirements);
    }

    private List<Long> findRequirementIds(Session session) {
        if (this.getCriterions().get(MILESTONE_IDS).getParameters() != null) {
            return this.idsByMilestones(session);
        }
        return this.idsByProject(session);
    }

    private List<Long> idsByMilestones(Session session) {
        Object[] milestoneIds = this.getCriterions().get(MILESTONE_IDS).getParameters();
        ArrayList<Long> mIds = new ArrayList<Long>(milestoneIds.length);
        Object[] objectArray = milestoneIds;
        int n = milestoneIds.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            mIds.add(Long.valueOf(o.toString()));
            ++n2;
        }
        String hql = "select req.id from Requirement req join req.versions version join version.milestones mstones where mstones.id in (:milestones)";
        Query q = session.createQuery(hql);
        q.setParameterList(MILESTONE_IDS, mIds, (Type)LongType.INSTANCE);
        return q.list();
    }

    private List<Long> idsByProject(Session session) {
        ArrayList<Long> projectIds = new ArrayList<Long>();
        boolean runOnAllProjects = true;
        if (this.getCriterions().get(PROJECT_IDS).getParameters() != null) {
            runOnAllProjects = false;
            Object[] objectArray = this.getCriterions().get(PROJECT_IDS).getParameters();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object id = objectArray[n2];
                projectIds.add(Long.parseLong((String)id));
                ++n2;
            }
        }
        String hql = "select req.id from Requirement req";
        if (!runOnAllProjects) {
            hql = String.valueOf(hql) + " where req.project.id in (:projectIds)";
        }
        Query query = session.createQuery(hql);
        if (!runOnAllProjects) {
            query.setParameterList("projectIds", projectIds, (Type)LongType.INSTANCE);
        }
        return query.list();
    }

    private List<Requirement> findRequirements(Session session, List<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        return session.createQuery("from Requirement where id in (:ids)").setParameterList("ids", ids, (Type)LongType.INSTANCE).list();
    }

    private List<Object[]> findParentsNames(Session session, List<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        return session.createSQLQuery(FIND_REQUIREMENT_PARENT_NAMES).setParameterList("reqIds", ids, (Type)LongType.INSTANCE).list();
    }

    private List<Object[]> pairRequirementAndParents(List<Requirement> requirements, List<Object[]> parentsNameOfRequirements) {
        LinkedList<Object[]> requirementsAndParents = new LinkedList<Object[]>();
        block0: for (Requirement req : requirements) {
            ListIterator<Object[]> iterNames = parentsNameOfRequirements.listIterator();
            while (iterNames.hasNext()) {
                Object[] tuple = iterNames.next();
                Long id = ((BigInteger)tuple[0]).longValue();
                if (!id.equals(req.getId())) continue;
                requirementsAndParents.add(new Object[]{req, tuple[1]});
                iterNames.remove();
                continue block0;
            }
        }
        return requirementsAndParents;
    }

    @Override
    public List<?> convertToDto(List<?> rawData) {
        List<Object[]> filteredData = this.filterUnwantedDataOut(rawData);
        Map<Long, ReqCoverageByTestProjectDto> projectList = this.populateRequirementDtosAndUpdateProjectStatistics(filteredData);
        ReqCoverageByTestProjectDto projectTotals = this.createProjectDto(TOTAL_PROJECT_NAME);
        this.calculateProjectsCoverageRates(projectList, projectTotals);
        this.calculateProjectCoverageRates(projectTotals);
        ArrayList<ReqCoverageByTestProjectDto> toReturn = new ArrayList<ReqCoverageByTestProjectDto>(projectList.values());
        toReturn.add(projectTotals);
        return toReturn;
    }

    private void calculateProjectsCoverageRates(Map<Long, ReqCoverageByTestProjectDto> projectList, ReqCoverageByTestProjectDto projectTotals) {
        for (ReqCoverageByTestProjectDto project : projectList.values()) {
            this.calculateProjectCoverageRates(project);
            projectTotals.increaseTotals(project.getRequirementNumbers(), project.getRequirementStatusNumbers());
        }
    }

    private Map<Long, ReqCoverageByTestProjectDto> populateRequirementDtosAndUpdateProjectStatistics(List<Object[]> filteredData) {
        if (filteredData.isEmpty()) {
            return new HashMap<Long, ReqCoverageByTestProjectDto>();
        }
        String milestone = this.extractMilestoneLabel((Requirement)filteredData.get(0)[0]);
        HashMap<Long, ReqCoverageByTestProjectDto> projectList = new HashMap<Long, ReqCoverageByTestProjectDto>();
        for (Object[] objects : filteredData) {
            Requirement requirement = (Requirement)objects[0];
            String parentName = (String)objects[1];
            Long projectId = requirement.getProject().getId();
            List<ReqCoverageByTestRequirementSingleDto> requirementSingleDtos = this.createRequirementSingleDtos(requirement, parentName);
            ReqCoverageByTestProjectDto currentProject = this.findProjectDto(projectList, requirement, projectId);
            if (milestone != null) {
                currentProject.setMilestone(milestone);
            }
            for (ReqCoverageByTestRequirementSingleDto requirementSingleDto : requirementSingleDtos) {
                currentProject.addRequirement(requirementSingleDto);
                this.updateProjectStatistics(currentProject, requirementSingleDto);
            }
        }
        return projectList;
    }

    private String extractMilestoneLabel(Requirement req) {
        Object[] ids;
        String milestone = null;
        ReportCriterion milestoneCrit = (ReportCriterion)this.criterions.get(MILESTONE_IDS);
        if (milestoneCrit != null && (ids = milestoneCrit.getParameters()) != null && ids.length > 0) {
            Long milestoneId = Long.valueOf(ids[0].toString());
            Project p = req.getProject();
            milestone = this.getMilestoneLabel(p, milestone, milestoneId);
        }
        return milestone;
    }

    private String getMilestoneLabel(Project p, String milestone, Long milestoneId) {
        for (Milestone m : p.getMilestones()) {
            if (!m.getId().equals(milestoneId)) continue;
            milestone = m.getLabel();
        }
        return milestone;
    }

    private ReqCoverageByTestProjectDto findProjectDto(Map<Long, ReqCoverageByTestProjectDto> projectList, Requirement requirement, Long projectId) {
        ReqCoverageByTestProjectDto currentProject;
        if (!projectList.containsKey(projectId)) {
            currentProject = this.createProjectDto(requirement);
            projectList.put(projectId, currentProject);
        } else {
            currentProject = projectList.get(projectId);
        }
        return currentProject;
    }

    private ReqCoverageByTestProjectDto createProjectDto(Requirement requirement) {
        String projectName = requirement.getProject().getName();
        return this.createProjectDto(projectName);
    }

    private ReqCoverageByTestProjectDto createProjectDto(String projectName) {
        ReqCoverageByTestProjectDto currentProject = new ReqCoverageByTestProjectDto();
        currentProject.setProjectName(projectName);
        return currentProject;
    }

    protected List<Object[]> filterUnwantedDataOut(List<Object[]> list) {
        LinkedList<Object[]> toReturn = new LinkedList<Object[]>();
        for (Object[] array : list) {
            Requirement requirement = (Requirement)array[0];
            if (!this.getDataFilteringService().isFullyAllowed(requirement)) continue;
            toReturn.add(array);
        }
        return toReturn;
    }

    private List<ReqCoverageByTestRequirementSingleDto> createRequirementSingleDtos(Requirement requirement, String parentName) {
        Object mode = ((ReportCriterion)this.criterions.get("mode")).getParameters()[0];
        int reqMode = Integer.parseInt((String)mode);
        ArrayList<ReqCoverageByTestRequirementSingleDto> reqCovByTestReqSingleDtos = new ArrayList<ReqCoverageByTestRequirementSingleDto>();
        switch (reqMode) {
            case 0: {
                LOGGER.debug("creation of reqCovByTestReqSingleDtos for Report mode 0 : only versions bound to the specified milestones are taken into account");
                this.createSingleDtoReportMilestoneVersion(requirement, parentName, reqCovByTestReqSingleDtos);
                break;
            }
            case 1: {
                LOGGER.debug("creation of reqCovByTestReqSingleDtos for Report mode 1 : all versions of requirement taken into account");
                this.createSingleDtoReportEachVersion(requirement, parentName, reqCovByTestReqSingleDtos);
                break;
            }
            case 2: {
                LOGGER.debug("creation of reqCovByTestReqSingleDtos for Report mode 2 : only last version of requirement taken into account");
                this.createSingleDtoReportLastVersion(requirement, parentName, reqCovByTestReqSingleDtos);
                break;
            }
            default: {
                LOGGER.warn("mode selection problem : default value");
                LOGGER.debug("creation of reqCovByTestReqSingleDtos for Report default mode : all versions of requirement taken into account");
                this.createSingleDtoReportEachVersion(requirement, parentName, reqCovByTestReqSingleDtos);
            }
        }
        return reqCovByTestReqSingleDtos;
    }

    private void createSingleDtoReportMilestoneVersion(Requirement requirement, String parentName, List<ReqCoverageByTestRequirementSingleDto> reqCovByTestReqSingleDtos) {
        Object[] oIds = this.getCriterions().get(MILESTONE_IDS).getParameters();
        ArrayList<Long> milestoneIds = new ArrayList<Long>(oIds.length);
        Object[] objectArray = oIds;
        int n = oIds.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            milestoneIds.add(Long.valueOf(o.toString()));
            ++n2;
        }
        List requirementVersions = requirement.getRequirementVersions();
        for (RequirementVersion version : requirementVersions) {
            for (Milestone m : version.getMilestones()) {
                if (!milestoneIds.contains(m.getId())) continue;
                ReqCoverageByTestRequirementSingleDto requirementSingleDto = this.createRequirementSingleDto(version, parentName, requirement);
                reqCovByTestReqSingleDtos.add(requirementSingleDto);
            }
        }
    }

    private void createSingleDtoReportEachVersion(Requirement requirement, String parentName, List<ReqCoverageByTestRequirementSingleDto> reqCovByTestReqSingleDtos) {
        List requirementVersions = requirement.getRequirementVersions();
        for (RequirementVersion version : requirementVersions) {
            ReqCoverageByTestRequirementSingleDto requirementSingleDto = this.createRequirementSingleDto(version, parentName, requirement);
            reqCovByTestReqSingleDtos.add(requirementSingleDto);
        }
    }

    private ReqCoverageByTestRequirementSingleDto createRequirementSingleDto(RequirementVersion version, String parentName, Requirement requirement) {
        ReqCoverageByTestRequirementSingleDto requirementSingleDto = new ReqCoverageByTestRequirementSingleDto();
        requirementSingleDto.setLabel(version.getName());
        requirementSingleDto.setReference(requirement.getReference());
        requirementSingleDto.setCriticality(version.getCriticality());
        requirementSingleDto.setStatus(version.getStatus());
        requirementSingleDto.setVersionNumber(version.getVersionNumber());
        int verifyingTestCases = version.getVerifyingTestCases().size();
        requirementSingleDto.setAssociatedTestCaseNumber(verifyingTestCases);
        if (parentName != null) {
            requirementSingleDto.setParent(parentName);
        }
        return requirementSingleDto;
    }

    private void createSingleDtoReportLastVersion(Requirement requirement, String parentName, List<ReqCoverageByTestRequirementSingleDto> reqCovByTestReqSingleDtos) {
        RequirementVersion lastVersion = requirement.getCurrentVersion();
        ReqCoverageByTestRequirementSingleDto requirementSingleDto = this.createRequirementSingleDto(lastVersion, parentName, requirement);
        reqCovByTestReqSingleDtos.add(requirementSingleDto);
    }

    private void updateProjectStatistics(ReqCoverageByTestProjectDto project, ReqCoverageByTestRequirementSingleDto requirementSingleDto) {
        project.incrementReqNumber(ReqCoverageByTestStatType.TOTAL);
        project.incrementReqStatusNumber(String.valueOf(requirementSingleDto.getStatus().toString()) + ReqCoverageByTestStatType.TOTAL.toString());
        boolean isVerifiedByTestCase = false;
        if (requirementSingleDto.hasAssociatedTestCases()) {
            isVerifiedByTestCase = true;
            project.incrementReqNumber(ReqCoverageByTestStatType.TOTAL_VERIFIED);
            project.incrementReqStatusNumber(String.valueOf(requirementSingleDto.getStatus().toString()) + ReqCoverageByTestStatType.TOTAL_VERIFIED.toString());
        }
        project.incrementReqNumber(requirementSingleDto.convertCrit());
        project.incrementReqStatusNumber(String.valueOf(requirementSingleDto.getStatus().toString()) + requirementSingleDto.convertCrit().toString());
        if (isVerifiedByTestCase) {
            project.incrementReqNumber(requirementSingleDto.convertCritVerif());
            project.incrementReqStatusNumber(String.valueOf(requirementSingleDto.getStatus().toString()) + requirementSingleDto.convertCritVerif().toString());
        }
    }

    private void calculateProjectCoverageRates(ReqCoverageByTestProjectDto givenProject) {
        this.calculateProjectCoverageRatesAllStatus(givenProject);
        this.calculateProjectCoverageRatesWorkInProgress(givenProject);
        this.calculateProjectCoverageRateUnderReview(givenProject);
        this.calculateProjectCoverageRateApproved(givenProject);
        this.calculateProjectCoverageRateObsolete(givenProject);
    }

    private void calculateProjectCoverageRateObsolete(ReqCoverageByTestProjectDto givenProject) {
        givenProject.setObsoleteGlobalRequirementCoverage(this.calculateAndRoundRate(givenProject.getObsoleteTotalVerifiedRequirementNumber(), givenProject.getObsoleteTotalRequirementNumber()));
        givenProject.setObsoleteCriticalRequirementCoverage(this.calculateAndRoundRate(givenProject.getObsoleteCriticalVerifiedRequirementNumber(), givenProject.getObsoleteCriticalRequirementNumber()));
        givenProject.setObsoleteMajorRequirementCoverage(this.calculateAndRoundRate(givenProject.getObsoleteMajorVerifiedRequirementNumber(), givenProject.getObsoleteMajorRequirementNumber()));
        givenProject.setObsoleteMinorRequirementCoverage(this.calculateAndRoundRate(givenProject.getObsoleteMinorVerifiedRequirementNumber(), givenProject.getObsoleteMinorRequirementNumber()));
        givenProject.setObsoleteUndefinedRequirementCoverage(this.calculateAndRoundRate(givenProject.getObsoleteUndefinedVerifiedRequirementNumber(), givenProject.getObsoleteUndefinedRequirementNumber()));
    }

    private void calculateProjectCoverageRateApproved(ReqCoverageByTestProjectDto givenProject) {
        givenProject.setApprovedGlobalRequirementCoverage(this.calculateAndRoundRate(givenProject.getApprovedTotalVerifiedRequirementNumber(), givenProject.getApprovedTotalRequirementNumber()));
        givenProject.setApprovedCriticalRequirementCoverage(this.calculateAndRoundRate(givenProject.getApprovedCriticalVerifiedRequirementNumber(), givenProject.getApprovedCriticalRequirementNumber()));
        givenProject.setApprovedMajorRequirementCoverage(this.calculateAndRoundRate(givenProject.getApprovedMajorVerifiedRequirementNumber(), givenProject.getApprovedMajorRequirementNumber()));
        givenProject.setApprovedMinorRequirementCoverage(this.calculateAndRoundRate(givenProject.getApprovedMinorVerifiedRequirementNumber(), givenProject.getApprovedMinorRequirementNumber()));
        givenProject.setApprovedUndefinedRequirementCoverage(this.calculateAndRoundRate(givenProject.getApprovedUndefinedVerifiedRequirementNumber(), givenProject.getApprovedUndefinedRequirementNumber()));
    }

    private void calculateProjectCoverageRateUnderReview(ReqCoverageByTestProjectDto givenProject) {
        givenProject.setUnderReviewGlobalRequirementCoverage(this.calculateAndRoundRate(givenProject.getUnderReviewTotalVerifiedRequirementNumber(), givenProject.getUnderReviewTotalRequirementNumber()));
        givenProject.setUnderReviewCriticalRequirementCoverage(this.calculateAndRoundRate(givenProject.getUnderReviewCriticalVerifiedRequirementNumber(), givenProject.getUnderReviewCriticalRequirementNumber()));
        givenProject.setUnderReviewMajorRequirementCoverage(this.calculateAndRoundRate(givenProject.getUnderReviewMajorVerifiedRequirementNumber(), givenProject.getUnderReviewMajorRequirementNumber()));
        givenProject.setUnderReviewMinorRequirementCoverage(this.calculateAndRoundRate(givenProject.getUnderReviewMinorVerifiedRequirementNumber(), givenProject.getUnderReviewMinorRequirementNumber()));
        givenProject.setUnderReviewUndefinedRequirementCoverage(this.calculateAndRoundRate(givenProject.getUnderReviewUndefinedVerifiedRequirementNumber(), givenProject.getUnderReviewUndefinedRequirementNumber()));
    }

    private void calculateProjectCoverageRatesWorkInProgress(ReqCoverageByTestProjectDto givenProject) {
        givenProject.setWorkInProgressGlobalRequirementCoverage(this.calculateAndRoundRate(givenProject.getWorkInProgressTotalVerifiedRequirementNumber(), givenProject.getWorkInProgressTotalRequirementNumber()));
        givenProject.setWorkInProgressCriticalRequirementCoverage(this.calculateAndRoundRate(givenProject.getWorkInProgressCriticalVerifiedRequirementNumber(), givenProject.getWorkInProgressCriticalRequirementNumber()));
        givenProject.setWorkInProgressMajorRequirementCoverage(this.calculateAndRoundRate(givenProject.getWorkInProgressMajorVerifiedRequirementNumber(), givenProject.getWorkInProgressMajorRequirementNumber()));
        givenProject.setWorkInProgressMinorRequirementCoverage(this.calculateAndRoundRate(givenProject.getWorkInProgressMinorVerifiedRequirementNumber(), givenProject.getWorkInProgressMinorRequirementNumber()));
        givenProject.setWorkInProgressUndefinedRequirementCoverage(this.calculateAndRoundRate(givenProject.getWorkInProgressUndefinedVerifiedRequirementNumber(), givenProject.getWorkInProgressUndefinedRequirementNumber()));
    }

    private void calculateProjectCoverageRatesAllStatus(ReqCoverageByTestProjectDto givenProject) {
        givenProject.setGlobalRequirementCoverage(this.calculateAndRoundRate(givenProject.getTotalVerifiedRequirementNumber(), givenProject.getTotalRequirementNumber()));
        givenProject.setCriticalRequirementCoverage(this.calculateAndRoundRate(givenProject.getCriticalVerifiedRequirementNumber(), givenProject.getCriticalRequirementNumber()));
        givenProject.setMajorRequirementCoverage(this.calculateAndRoundRate(givenProject.getMajorVerifiedRequirementNumber(), givenProject.getMajorRequirementNumber()));
        givenProject.setMinorRequirementCoverage(this.calculateAndRoundRate(givenProject.getMinorVerifiedRequirementNumber(), givenProject.getMinorRequirementNumber()));
        givenProject.setUndefinedRequirementCoverage(this.calculateAndRoundRate(givenProject.getUndefinedVerifiedRequirementNumber(), givenProject.getUndefinedRequirementNumber()));
    }

    private byte calculateAndRoundRate(Long verifiedNumber, Long totalNumber) {
        Double result = 100.0;
        if (totalNumber > 0L) {
            result = (double)verifiedNumber.longValue() * 100.0 / (double)totalNumber.longValue();
        }
        result = Math.floor(result + 0.5);
        return result.byteValue();
    }

    private static class MilestoneIdsIsInIds
    extends IsInSet<Long> {
        public MilestoneIdsIsInIds(String criterionName, String attributePath, Class<?> entityClass, String entityAlias) {
            super(criterionName, attributePath, entityClass, entityAlias);
        }

        @Override
        public Long fromValueToTypedValue(Object o) {
            return Long.parseLong(o.toString());
        }
    }

    private static class ProjectIdsIsInIds
    extends IsInSet<Long> {
        public ProjectIdsIsInIds(String criterionName, String attributePath, Class<?> entityClass, String entityAlias) {
            super(criterionName, attributePath, entityClass, entityAlias);
        }

        @Override
        public Long fromValueToTypedValue(Object o) {
            return Long.parseLong(o.toString());
        }
    }
}

