/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.internal.domain.report.common.hibernate;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.internal.domain.report.query.QueryOperator;
import org.squashtest.tm.internal.domain.report.query.hibernate.ReportCriterion;

public class BelowDateCriterion
extends ReportCriterion {
    private static final Logger LOGGER = LoggerFactory.getLogger(BelowDateCriterion.class);

    public BelowDateCriterion() {
        this.setOperator(QueryOperator.COMPARATOR_LT);
        this.setParamClass(Date.class);
    }

    public BelowDateCriterion(String criterionName, String attributePath) {
        this();
        this.setCriterionName(criterionName);
        this.setAttributePath(attributePath);
    }

    private Date makeDate() throws IllegalArgumentException {
        Object[] values = this.getParameters();
        if (values.length != 1) {
            throw new IllegalArgumentException("Criterion of type " + this.getClass().getSimpleName() + " cannot have more than one argument");
        }
        Date date = (Date)values[0];
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        return calendar.getTime();
    }

    @Override
    public Criterion makeCriterion() {
        try {
            Date arg = this.makeDate();
            SimpleExpression result = Restrictions.lt((String)this.getAttributePath(), (Object)arg);
            return result;
        }
        catch (ClassCastException | IllegalArgumentException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

