/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.internal.domain.report.query.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.squashtest.tm.internal.domain.report.query.ReportQuery;
import org.squashtest.tm.internal.domain.report.query.jpa.AbstractJpaReportCriterion;
import org.squashtest.tm.plugin.report.std.service.DataFilteringService;

public abstract class AbstractJpaReportQuery<T>
implements ReportQuery {
    protected Map<String, AbstractJpaReportCriterion> criteriaByName = new HashMap<String, AbstractJpaReportCriterion>();
    private DataFilteringService filterService;

    @Override
    public void setCriterion(String name, Object ... parameters) {
        AbstractJpaReportCriterion criterion = this.criteriaByName.get(name);
        if (criterion == null) {
            throw new IllegalArgumentException("parameter %s does not exists for query %s".formatted(name, this.getClass().getSimpleName()));
        }
        criterion.setParameter(parameters);
    }

    @Override
    public void setDataFilteringService(DataFilteringService service) {
        this.filterService = service;
    }

    protected Class<T> getEntityType() {
        throw new UnsupportedOperationException("Not implemented. You should override this method.");
    }

    public <D> List<D> execute(EntityManager entityManager) {
        throw new UnsupportedOperationException("Not implemented. You should override this method.");
    }

    public abstract <R, D> List<D> convertToDto(List<R> var1);

    protected DataFilteringService getDataFilteringService() {
        return this.filterService;
    }

    @Override
    public Collection<String> getCriterionNames() {
        return this.criteriaByName.keySet();
    }

    @Override
    public Object[] getValue(String key) {
        AbstractJpaReportCriterion criterion = this.criteriaByName.get(key);
        if (criterion != null) {
            return criterion.getParameters();
        }
        return new Object[0];
    }

    public abstract boolean isCriteriaQueryBased();

    public CriteriaQuery<T> buildCriteriaQuery(EntityManager entityManager) {
        Class<T> entityType = this.getEntityType();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(entityType);
        Root root = criteriaQuery.from(entityType);
        List<Predicate> predicates = this.buildAllPredicates(criteriaBuilder, root);
        criteriaQuery.select((Selection)root).where(predicates.toArray(new Predicate[0]));
        return criteriaQuery;
    }

    private List<Predicate> buildAllPredicates(CriteriaBuilder cb, Root<?> root) {
        return this.criteriaByName.values().stream().map(abstractJpaReportCriterion -> abstractJpaReportCriterion.makePredicate(cb, root)).toList();
    }
}

