/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.internal.domain.report.common.dto;

import java.util.List;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.internal.domain.report.common.dto.ExProgressIterationDto;

public class ExProgressTestPlanDto {
    private String testCaseName;
    private ExecutionStatus executionStatus;
    private ExProgressIterationDto iteration;
    private String testSuitesNames;
    private String datasetNames;

    public ExProgressTestPlanDto() {
    }

    public ExProgressTestPlanDto(String testCaseName, ExecutionStatus executionStatus) {
        this.testCaseName = testCaseName;
        this.executionStatus = executionStatus;
    }

    public ExProgressIterationDto getIteration() {
        return this.iteration;
    }

    public void setIteration(ExProgressIterationDto iteration) {
        this.iteration = iteration;
    }

    public String getTestCaseName() {
        return this.testCaseName;
    }

    public void setTestCaseName(String testCaseName) {
        this.testCaseName = testCaseName;
    }

    public ExecutionStatus getExecutionStatus() {
        return this.executionStatus;
    }

    public void setExecutionStatus(ExecutionStatus executionStatus) {
        this.executionStatus = executionStatus;
    }

    public String getTestSuitesNames() {
        return this.testSuitesNames;
    }

    public void setTestSuitesNames(String testSuitesNames) {
        this.testSuitesNames = testSuitesNames;
    }

    public String getDatasetNames() {
        return this.datasetNames;
    }

    public void setDatasetNames(String datasetNames) {
        this.datasetNames = datasetNames;
    }

    public ExProgressTestPlanDto fillBasicInfo(TestPlanItem testPlanItem) {
        String reference;
        this.testCaseName = testPlanItem.isTestCaseDeleted() ? null : ((reference = testPlanItem.getReferencedTestCase().getReference()) != null && reference.isEmpty() ? (testPlanItem.isTestCaseDeleted() ? null : testPlanItem.getReferencedTestCase().getName()) : (testPlanItem.isTestCaseDeleted() ? null : reference + " - " + testPlanItem.getReferencedTestCase().getName()));
        this.testSuitesNames = this.buildTestSuitesNames(testPlanItem);
        this.datasetNames = testPlanItem.getReferencedDataset() != null ? testPlanItem.getReferencedDataset().getName() : "--";
        this.executionStatus = testPlanItem.getExecutionStatus();
        return this;
    }

    private String buildTestSuitesNames(TestPlanItem testPlanItem) {
        List<String> testSuitesLabels = testPlanItem.getTestSuites().stream().map(TestSuite::getName).toList();
        return this.appendListItemsIntoASingleString(testSuitesLabels);
    }

    private String appendListItemsIntoASingleString(List<String> stringList) {
        String prefix = "";
        StringBuilder result = new StringBuilder();
        for (String string : stringList) {
            result.append(prefix);
            prefix = ", ";
            result.append(string);
        }
        return result.toString();
    }
}

