/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.internal.domain.report.common.dto;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.internal.domain.report.common.dto.HasMilestoneLabel;
import org.squashtest.tm.internal.domain.report.common.dto.ReqCoverageByTestRequirementSingleDto;
import org.squashtest.tm.internal.domain.report.common.dto.ReqCoverageByTestStatType;

public class ReqCoverageByTestProjectDto
implements HasMilestoneLabel {
    private String milestone;
    private String projectName;
    private List<ReqCoverageByTestRequirementSingleDto> singleRequirementList = new ArrayList<ReqCoverageByTestRequirementSingleDto>();
    private EnumMap<ReqCoverageByTestStatType, Long> requirementNumbers = new EnumMap(ReqCoverageByTestStatType.class);
    private Map<String, Long> requirementStatusNumbers = new HashMap<String, Long>();
    private Byte globalRequirementCoverage;
    private Byte criticalRequirementCoverage;
    private Byte majorRequirementCoverage;
    private Byte minorRequirementCoverage;
    private Byte undefinedRequirementCoverage;
    private Byte workInProgressGlobalRequirementCoverage;
    private Byte workInProgressCriticalRequirementCoverage;
    private Byte workInProgressMajorRequirementCoverage;
    private Byte workInProgressMinorRequirementCoverage;
    private Byte workInProgressUndefinedRequirementCoverage;
    private Byte underReviewGlobalRequirementCoverage;
    private Byte underReviewCriticalRequirementCoverage;
    private Byte underReviewMajorRequirementCoverage;
    private Byte underReviewMinorRequirementCoverage;
    private Byte underReviewUndefinedRequirementCoverage;
    private Byte approvedGlobalRequirementCoverage;
    private Byte approvedCriticalRequirementCoverage;
    private Byte approvedMajorRequirementCoverage;
    private Byte approvedMinorRequirementCoverage;
    private Byte approvedUndefinedRequirementCoverage;
    private Byte obsoleteGlobalRequirementCoverage;
    private Byte obsoleteCriticalRequirementCoverage;
    private Byte obsoleteMajorRequirementCoverage;
    private Byte obsoleteMinorRequirementCoverage;
    private Byte obsoleteUndefinedRequirementCoverage;

    public ReqCoverageByTestProjectDto() {
        ReqCoverageByTestStatType[] reqCoverageByTestStatTypeArray = ReqCoverageByTestStatType.values();
        int n = reqCoverageByTestStatTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReqCoverageByTestStatType reqStatType = reqCoverageByTestStatTypeArray[n2];
            this.requirementNumbers.put(reqStatType, 0L);
            ++n2;
        }
        reqCoverageByTestStatTypeArray = RequirementStatus.values();
        n = reqCoverageByTestStatTypeArray.length;
        n2 = 0;
        while (n2 < n) {
            ReqCoverageByTestStatType status = reqCoverageByTestStatTypeArray[n2];
            ReqCoverageByTestStatType[] reqCoverageByTestStatTypeArray2 = ReqCoverageByTestStatType.values();
            int n3 = reqCoverageByTestStatTypeArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                ReqCoverageByTestStatType reqStatType = reqCoverageByTestStatTypeArray2[n4];
                String key = status.toString() + reqStatType.toString();
                this.requirementStatusNumbers.put(key, 0L);
                ++n4;
            }
            ++n2;
        }
    }

    public void incrementReqNumber(ReqCoverageByTestStatType type) {
        Long number = this.requirementNumbers.get((Object)type);
        number = number + 1L;
        this.requirementNumbers.put(type, number);
    }

    public void incrementReqStatusNumber(String key) {
        Long number = this.requirementStatusNumbers.get(key);
        number = number + 1L;
        this.requirementStatusNumbers.put(key, number);
    }

    public void increaseTotals(Map<ReqCoverageByTestStatType, Long> requirementNumbers2, Map<String, Long> requirementStatusNumbers2) {
        Long reqNumber;
        Object concernedType;
        for (Map.Entry<ReqCoverageByTestStatType, Long> entry : requirementNumbers2.entrySet()) {
            concernedType = entry.getKey();
            reqNumber = this.requirementNumbers.get(concernedType);
            reqNumber = reqNumber + entry.getValue();
            this.requirementNumbers.put((ReqCoverageByTestStatType)((Object)concernedType), reqNumber);
        }
        for (Map.Entry<Object, Long> entry : requirementStatusNumbers2.entrySet()) {
            concernedType = (String)entry.getKey();
            reqNumber = this.requirementStatusNumbers.get(concernedType);
            reqNumber = reqNumber + entry.getValue();
            this.requirementStatusNumbers.put((String)concernedType, reqNumber);
        }
    }

    public List<ReqCoverageByTestRequirementSingleDto> getSingleRequirementList() {
        return this.singleRequirementList;
    }

    public void addRequirement(ReqCoverageByTestRequirementSingleDto requirementSingleDto) {
        this.singleRequirementList.add(requirementSingleDto);
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public Long getTotalRequirementNumber() {
        return this.requirementNumbers.get((Object)ReqCoverageByTestStatType.TOTAL);
    }

    public Long getTotalVerifiedRequirementNumber() {
        return this.requirementNumbers.get((Object)ReqCoverageByTestStatType.TOTAL_VERIFIED);
    }

    public Long getCriticalRequirementNumber() {
        return this.requirementNumbers.get((Object)ReqCoverageByTestStatType.CRITICAL);
    }

    public Long getCriticalVerifiedRequirementNumber() {
        return this.requirementNumbers.get((Object)ReqCoverageByTestStatType.CRITICAL_VERIFIED);
    }

    public Long getMajorRequirementNumber() {
        return this.requirementNumbers.get((Object)ReqCoverageByTestStatType.MAJOR);
    }

    public Long getMajorVerifiedRequirementNumber() {
        return this.requirementNumbers.get((Object)ReqCoverageByTestStatType.MAJOR_VERIFIED);
    }

    public Long getMinorRequirementNumber() {
        return this.requirementNumbers.get((Object)ReqCoverageByTestStatType.MINOR);
    }

    public Long getMinorVerifiedRequirementNumber() {
        return this.requirementNumbers.get((Object)ReqCoverageByTestStatType.MINOR_VERIFIED);
    }

    public Long getUndefinedRequirementNumber() {
        return this.requirementNumbers.get((Object)ReqCoverageByTestStatType.UNDEFINED);
    }

    public Long getUndefinedVerifiedRequirementNumber() {
        return this.requirementNumbers.get((Object)ReqCoverageByTestStatType.UNDEFINED_VERIFIED);
    }

    public Byte getGlobalRequirementCoverage() {
        return this.globalRequirementCoverage;
    }

    public Byte getCriticalRequirementCoverage() {
        return this.criticalRequirementCoverage;
    }

    public Byte getMajorRequirementCoverage() {
        return this.majorRequirementCoverage;
    }

    public Byte getMinorRequirementCoverage() {
        return this.minorRequirementCoverage;
    }

    public Byte getUndefinedRequirementCoverage() {
        return this.undefinedRequirementCoverage;
    }

    public void setGlobalRequirementCoverage(Byte globalRequirementCoverage) {
        this.globalRequirementCoverage = globalRequirementCoverage;
    }

    public void setCriticalRequirementCoverage(Byte criticalRequirementCoverage) {
        this.criticalRequirementCoverage = criticalRequirementCoverage;
    }

    public void setMajorRequirementCoverage(Byte majorRequirementCoverage) {
        this.majorRequirementCoverage = majorRequirementCoverage;
    }

    public void setMinorRequirementCoverage(Byte minorRequirementCoverage) {
        this.minorRequirementCoverage = minorRequirementCoverage;
    }

    public void setUndefinedRequirementCoverage(Byte undefinedRequirementCoverage) {
        this.undefinedRequirementCoverage = undefinedRequirementCoverage;
    }

    public Map<ReqCoverageByTestStatType, Long> getRequirementNumbers() {
        return this.requirementNumbers;
    }

    public void setRequirementNumbers(Map<ReqCoverageByTestStatType, Long> requirementNumbers) {
        this.requirementNumbers = (EnumMap)requirementNumbers;
    }

    public Long getWorkInProgressTotalRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.WORK_IN_PROGRESS.toString() + ReqCoverageByTestStatType.TOTAL.toString());
    }

    public Long getWorkInProgressTotalVerifiedRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.WORK_IN_PROGRESS.toString() + ReqCoverageByTestStatType.TOTAL_VERIFIED.toString());
    }

    public Long getWorkInProgressCriticalRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.WORK_IN_PROGRESS.toString() + ReqCoverageByTestStatType.CRITICAL.toString());
    }

    public Long getWorkInProgressCriticalVerifiedRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.WORK_IN_PROGRESS.toString() + ReqCoverageByTestStatType.CRITICAL_VERIFIED.toString());
    }

    public Long getWorkInProgressMajorRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.WORK_IN_PROGRESS.toString() + ReqCoverageByTestStatType.MAJOR.toString());
    }

    public Long getWorkInProgressMajorVerifiedRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.WORK_IN_PROGRESS.toString() + ReqCoverageByTestStatType.MAJOR_VERIFIED.toString());
    }

    public Long getWorkInProgressMinorRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.WORK_IN_PROGRESS.toString() + ReqCoverageByTestStatType.MINOR.toString());
    }

    public Long getWorkInProgressMinorVerifiedRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.WORK_IN_PROGRESS.toString() + ReqCoverageByTestStatType.MINOR_VERIFIED.toString());
    }

    public Long getWorkInProgressUndefinedRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.WORK_IN_PROGRESS.toString() + ReqCoverageByTestStatType.UNDEFINED.toString());
    }

    public Long getWorkInProgressUndefinedVerifiedRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.WORK_IN_PROGRESS.toString() + ReqCoverageByTestStatType.UNDEFINED_VERIFIED.toString());
    }

    public Long getUnderReviewTotalRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.UNDER_REVIEW.toString() + ReqCoverageByTestStatType.TOTAL.toString());
    }

    public Long getUnderReviewTotalVerifiedRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.UNDER_REVIEW.toString() + ReqCoverageByTestStatType.TOTAL_VERIFIED.toString());
    }

    public Long getUnderReviewCriticalRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.UNDER_REVIEW.toString() + ReqCoverageByTestStatType.CRITICAL.toString());
    }

    public Long getUnderReviewCriticalVerifiedRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.UNDER_REVIEW.toString() + ReqCoverageByTestStatType.CRITICAL_VERIFIED.toString());
    }

    public Long getUnderReviewMajorRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.UNDER_REVIEW.toString() + ReqCoverageByTestStatType.MAJOR.toString());
    }

    public Long getUnderReviewMajorVerifiedRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.UNDER_REVIEW.toString() + ReqCoverageByTestStatType.MAJOR_VERIFIED.toString());
    }

    public Long getUnderReviewMinorRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.UNDER_REVIEW.toString() + ReqCoverageByTestStatType.MINOR.toString());
    }

    public Long getUnderReviewMinorVerifiedRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.UNDER_REVIEW.toString() + ReqCoverageByTestStatType.MINOR_VERIFIED.toString());
    }

    public Long getUnderReviewUndefinedRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.UNDER_REVIEW.toString() + ReqCoverageByTestStatType.UNDEFINED.toString());
    }

    public Long getUnderReviewUndefinedVerifiedRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.UNDER_REVIEW.toString() + ReqCoverageByTestStatType.UNDEFINED_VERIFIED.toString());
    }

    public Long getApprovedTotalRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.APPROVED.toString() + ReqCoverageByTestStatType.TOTAL.toString());
    }

    public Long getApprovedTotalVerifiedRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.APPROVED.toString() + ReqCoverageByTestStatType.TOTAL_VERIFIED.toString());
    }

    public Long getApprovedCriticalRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.APPROVED.toString() + ReqCoverageByTestStatType.CRITICAL.toString());
    }

    public Long getApprovedCriticalVerifiedRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.APPROVED.toString() + ReqCoverageByTestStatType.CRITICAL_VERIFIED.toString());
    }

    public Long getApprovedMajorRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.APPROVED.toString() + ReqCoverageByTestStatType.MAJOR.toString());
    }

    public Long getApprovedMajorVerifiedRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.APPROVED.toString() + ReqCoverageByTestStatType.MAJOR_VERIFIED.toString());
    }

    public Long getApprovedMinorRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.APPROVED.toString() + ReqCoverageByTestStatType.MINOR.toString());
    }

    public Long getApprovedMinorVerifiedRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.APPROVED.toString() + ReqCoverageByTestStatType.MINOR_VERIFIED.toString());
    }

    public Long getApprovedUndefinedRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.APPROVED.toString() + ReqCoverageByTestStatType.UNDEFINED.toString());
    }

    public Long getApprovedUndefinedVerifiedRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.APPROVED.toString() + ReqCoverageByTestStatType.UNDEFINED_VERIFIED.toString());
    }

    public Long getObsoleteTotalRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.OBSOLETE.toString() + ReqCoverageByTestStatType.TOTAL.toString());
    }

    public Long getObsoleteTotalVerifiedRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.OBSOLETE.toString() + ReqCoverageByTestStatType.TOTAL_VERIFIED.toString());
    }

    public Long getObsoleteCriticalRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.OBSOLETE.toString() + ReqCoverageByTestStatType.CRITICAL.toString());
    }

    public Long getObsoleteCriticalVerifiedRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.OBSOLETE.toString() + ReqCoverageByTestStatType.CRITICAL_VERIFIED.toString());
    }

    public Long getObsoleteMajorRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.OBSOLETE.toString() + ReqCoverageByTestStatType.MAJOR.toString());
    }

    public Long getObsoleteMajorVerifiedRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.OBSOLETE.toString() + ReqCoverageByTestStatType.MAJOR_VERIFIED.toString());
    }

    public Long getObsoleteMinorRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.OBSOLETE.toString() + ReqCoverageByTestStatType.MINOR.toString());
    }

    public Long getObsoleteMinorVerifiedRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.OBSOLETE.toString() + ReqCoverageByTestStatType.MINOR_VERIFIED.toString());
    }

    public Long getObsoleteUndefinedRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.OBSOLETE.toString() + ReqCoverageByTestStatType.UNDEFINED.toString());
    }

    public Long getObsoleteUndefinedVerifiedRequirementNumber() {
        return this.requirementStatusNumbers.get(RequirementStatus.OBSOLETE.toString() + ReqCoverageByTestStatType.UNDEFINED_VERIFIED.toString());
    }

    public Byte getWorkInProgressGlobalRequirementCoverage() {
        return this.workInProgressGlobalRequirementCoverage;
    }

    public Byte getWorkInProgressCriticalRequirementCoverage() {
        return this.workInProgressCriticalRequirementCoverage;
    }

    public Byte getWorkInProgressMajorRequirementCoverage() {
        return this.workInProgressMajorRequirementCoverage;
    }

    public Byte getWorkInProgressMinorRequirementCoverage() {
        return this.workInProgressMinorRequirementCoverage;
    }

    public Byte getWorkInProgressUndefinedRequirementCoverage() {
        return this.workInProgressUndefinedRequirementCoverage;
    }

    public Byte getUnderReviewGlobalRequirementCoverage() {
        return this.underReviewGlobalRequirementCoverage;
    }

    public Byte getUnderReviewCriticalRequirementCoverage() {
        return this.underReviewCriticalRequirementCoverage;
    }

    public Byte getUnderReviewMajorRequirementCoverage() {
        return this.underReviewMajorRequirementCoverage;
    }

    public Byte getUnderReviewMinorRequirementCoverage() {
        return this.underReviewMinorRequirementCoverage;
    }

    public Byte getUnderReviewUndefinedRequirementCoverage() {
        return this.underReviewUndefinedRequirementCoverage;
    }

    public Byte getApprovedGlobalRequirementCoverage() {
        return this.approvedGlobalRequirementCoverage;
    }

    public Byte getApprovedCriticalRequirementCoverage() {
        return this.approvedCriticalRequirementCoverage;
    }

    public Byte getApprovedMajorRequirementCoverage() {
        return this.approvedMajorRequirementCoverage;
    }

    public Byte getApprovedMinorRequirementCoverage() {
        return this.approvedMinorRequirementCoverage;
    }

    public Byte getApprovedUndefinedRequirementCoverage() {
        return this.approvedUndefinedRequirementCoverage;
    }

    public Byte getObsoleteGlobalRequirementCoverage() {
        return this.obsoleteGlobalRequirementCoverage;
    }

    public Byte getObsoleteCriticalRequirementCoverage() {
        return this.obsoleteCriticalRequirementCoverage;
    }

    public Byte getObsoleteMajorRequirementCoverage() {
        return this.obsoleteMajorRequirementCoverage;
    }

    public Byte getObsoleteMinorRequirementCoverage() {
        return this.obsoleteMinorRequirementCoverage;
    }

    public Byte getObsoleteUndefinedRequirementCoverage() {
        return this.obsoleteUndefinedRequirementCoverage;
    }

    public void setWorkInProgressGlobalRequirementCoverage(Byte workInProgressGlobalRequirementCoverage) {
        this.workInProgressGlobalRequirementCoverage = workInProgressGlobalRequirementCoverage;
    }

    public void setWorkInProgressCriticalRequirementCoverage(Byte workInProgressCriticalRequirementCoverage) {
        this.workInProgressCriticalRequirementCoverage = workInProgressCriticalRequirementCoverage;
    }

    public void setWorkInProgressMajorRequirementCoverage(Byte workInProgressMajorRequirementCoverage) {
        this.workInProgressMajorRequirementCoverage = workInProgressMajorRequirementCoverage;
    }

    public void setWorkInProgressMinorRequirementCoverage(Byte workInProgressMinorRequirementCoverage) {
        this.workInProgressMinorRequirementCoverage = workInProgressMinorRequirementCoverage;
    }

    public void setWorkInProgressUndefinedRequirementCoverage(Byte workInProgressUndefinedRequirementCoverage) {
        this.workInProgressUndefinedRequirementCoverage = workInProgressUndefinedRequirementCoverage;
    }

    public void setUnderReviewGlobalRequirementCoverage(Byte underReviewGlobalRequirementCoverage) {
        this.underReviewGlobalRequirementCoverage = underReviewGlobalRequirementCoverage;
    }

    public void setUnderReviewCriticalRequirementCoverage(Byte underReviewCriticalRequirementCoverage) {
        this.underReviewCriticalRequirementCoverage = underReviewCriticalRequirementCoverage;
    }

    public void setUnderReviewMajorRequirementCoverage(Byte underReviewMajorRequirementCoverage) {
        this.underReviewMajorRequirementCoverage = underReviewMajorRequirementCoverage;
    }

    public void setUnderReviewMinorRequirementCoverage(Byte underReviewMinorRequirementCoverage) {
        this.underReviewMinorRequirementCoverage = underReviewMinorRequirementCoverage;
    }

    public void setUnderReviewUndefinedRequirementCoverage(Byte underReviewUndefinedRequirementCoverage) {
        this.underReviewUndefinedRequirementCoverage = underReviewUndefinedRequirementCoverage;
    }

    public void setApprovedGlobalRequirementCoverage(Byte approvedGlobalRequirementCoverage) {
        this.approvedGlobalRequirementCoverage = approvedGlobalRequirementCoverage;
    }

    public void setApprovedCriticalRequirementCoverage(Byte approvedCriticalRequirementCoverage) {
        this.approvedCriticalRequirementCoverage = approvedCriticalRequirementCoverage;
    }

    public void setApprovedMajorRequirementCoverage(Byte approvedMajorRequirementCoverage) {
        this.approvedMajorRequirementCoverage = approvedMajorRequirementCoverage;
    }

    public void setApprovedMinorRequirementCoverage(Byte approvedMinorRequirementCoverage) {
        this.approvedMinorRequirementCoverage = approvedMinorRequirementCoverage;
    }

    public void setApprovedUndefinedRequirementCoverage(Byte approvedUndefinedRequirementCoverage) {
        this.approvedUndefinedRequirementCoverage = approvedUndefinedRequirementCoverage;
    }

    public void setObsoleteGlobalRequirementCoverage(Byte obsoleteGlobalRequirementCoverage) {
        this.obsoleteGlobalRequirementCoverage = obsoleteGlobalRequirementCoverage;
    }

    public void setObsoleteCriticalRequirementCoverage(Byte obsoleteCriticalRequirementCoverage) {
        this.obsoleteCriticalRequirementCoverage = obsoleteCriticalRequirementCoverage;
    }

    public void setObsoleteMajorRequirementCoverage(Byte obsoleteMajorRequirementCoverage) {
        this.obsoleteMajorRequirementCoverage = obsoleteMajorRequirementCoverage;
    }

    public void setObsoleteMinorRequirementCoverage(Byte obsoleteMinorRequirementCoverage) {
        this.obsoleteMinorRequirementCoverage = obsoleteMinorRequirementCoverage;
    }

    public void setObsoleteUndefinedRequirementCoverage(Byte obsoleteUndefinedRequirementCoverage) {
        this.obsoleteUndefinedRequirementCoverage = obsoleteUndefinedRequirementCoverage;
    }

    public Map<String, Long> getRequirementStatusNumbers() {
        return this.requirementStatusNumbers;
    }

    @Override
    public String getMilestone() {
        return this.milestone;
    }

    public void setMilestone(String milestone) {
        this.milestone = milestone;
    }
}

