/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.internal.service;

import org.springframework.osgi.extensions.annotation.ServiceReference;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.project.ProjectResource;
import org.squashtest.tm.domain.projectfilter.ProjectFilter;
import org.squashtest.tm.plugin.report.std.service.DataFilteringService;
import org.squashtest.tm.service.project.ProjectFilterModificationService;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service(value="squashtest.tm.service.DataFilteringService")
public class DataFilteringServiceImpl
implements DataFilteringService {
    private PermissionEvaluationService permissionService;
    private ProjectFilterModificationService userFilterService;

    @ServiceReference
    public void setPermissionEvaluationService(PermissionEvaluationService service) {
        this.permissionService = service;
    }

    @Override
    public boolean isFullyAllowed(Object object) {
        return this.hasReadPermissions(object) && (!(object instanceof ProjectResource) || this.isAllowedByUser((ProjectResource)object));
    }

    @Override
    public boolean hasReadPermissions(Object object) {
        return this.permissionService.canRead(object);
    }

    @Override
    public boolean isAllowedByUser(ProjectResource object) {
        ProjectFilter filter = this.userFilterService.findProjectFilterByUserLogin();
        return filter.getActivated() != false ? filter.isProjectSelected(object.getProject()) : true;
    }

    @ServiceReference
    public void setUserFilterService(ProjectFilterModificationService userFilterService) {
        this.userFilterService = userFilterService;
    }

    @ServiceReference
    public void setPermissionService(PermissionEvaluationService permissionService) {
        this.permissionService = permissionService;
    }
}

