/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.internal.domain.report.common.dto;

import java.util.LinkedList;
import java.util.List;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.internal.domain.report.common.dto.ExProgressIterationDto;
import org.squashtest.tm.internal.domain.report.common.dto.ExProgressProjectDto;
import org.squashtest.tm.internal.domain.report.common.dto.ExProgressScheduledAbstractDto;

public class ExProgressCampaignDto
extends ExProgressScheduledAbstractDto {
    private ExProgressProjectDto project;
    private List<ExProgressIterationDto> iterations = new LinkedList<ExProgressIterationDto>();

    public ExProgressCampaignDto() {
    }

    public ExProgressCampaignDto(Campaign campaign) {
        this.fillBasicInfos(campaign);
        this.fillIterationsInfos(campaign);
    }

    public ExProgressProjectDto getProject() {
        return this.project;
    }

    public void setProject(ExProgressProjectDto project) {
        this.project = project;
    }

    public List<ExProgressIterationDto> getIterations() {
        return this.iterations;
    }

    public void setIterations(List<ExProgressIterationDto> iterations) {
        this.iterations = iterations;
    }

    public void addIterationDto(ExProgressIterationDto iterDto) {
        this.iterations.add(iterDto);
    }

    public ExProgressCampaignDto fillBasicInfos(Campaign campaign) {
        this.name = campaign.getName();
        this.scheduledStartDate = campaign.getScheduledStartDate();
        this.scheduledEndDate = campaign.getScheduledEndDate();
        this.actualStartDate = campaign.getActualStartDate();
        this.actualEndDate = campaign.getActualEndDate();
        return this;
    }

    public ExProgressCampaignDto fillIterationsInfos(Campaign campaign) {
        for (Iteration iteration : campaign.getIterations()) {
            ExProgressIterationDto iterDto = new ExProgressIterationDto(iteration);
            this.iterations.add(iterDto);
        }
        return this;
    }
}

