/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.internal.domain.report.common.hibernate;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.squashtest.tm.internal.domain.report.query.QueryOperator;
import org.squashtest.tm.internal.domain.report.query.hibernate.ReportCriterion;

public class BelowDateCriterion
extends ReportCriterion {
    public BelowDateCriterion() {
        this.setOperator(QueryOperator.COMPARATOR_LT);
        this.setParamClass(Date.class);
    }

    public BelowDateCriterion(String criterionName, String attributePath) {
        this();
        this.setCriterionName(criterionName);
        this.setAttributePath(attributePath);
    }

    private Date makeDate() {
        Object[] values = this.getParameters();
        if (values.length != 1) {
            throw new IllegalArgumentException("Criterion of type " + this.getClass().getSimpleName() + " cannot have more than one argument");
        }
        String strDate = values[0].toString();
        Long lDate = Long.parseLong(strDate);
        Date date = new Date(lDate);
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        return calendar.getTime();
    }

    @Override
    public Criterion makeCriterion() {
        try {
            SimpleExpression result = null;
            Date arg = this.makeDate();
            result = Restrictions.lt((String)this.getAttributePath(), (Object)arg);
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

