/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.internal.domain.report.common.dto;

import java.util.LinkedList;
import java.util.List;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.internal.domain.report.common.dto.ExProgressCampaignDto;
import org.squashtest.tm.internal.domain.report.common.dto.ExProgressScheduledAbstractDto;
import org.squashtest.tm.internal.domain.report.common.dto.ExProgressTestPlanDto;
import org.squashtest.tm.internal.domain.report.common.dto.ExProgressTestSuiteDto;

public class ExProgressIterationDto
extends ExProgressScheduledAbstractDto {
    private ExProgressCampaignDto campaign;
    private List<ExProgressTestPlanDto> testPlans = new LinkedList<ExProgressTestPlanDto>();
    private List<ExProgressTestSuiteDto> testSuites = new LinkedList<ExProgressTestSuiteDto>();

    public ExProgressCampaignDto getCampaign() {
        return this.campaign;
    }

    public void setCampaign(ExProgressCampaignDto campaign) {
        this.campaign = campaign;
    }

    public ExProgressIterationDto(Iteration iteration) {
        this.fillBasicInfos(iteration);
        this.fillStatusInfos(iteration.getTestPlans());
        this.fillTestSuiteInfos(iteration);
    }

    private void fillTestSuiteInfos(Iteration iteration) {
        for (TestSuite testSuite : iteration.getTestSuites()) {
            ExProgressTestSuiteDto testSuiteDto = new ExProgressTestSuiteDto(testSuite);
            this.testSuites.add(testSuiteDto);
        }
    }

    public List<ExProgressTestPlanDto> getTestPlans() {
        return this.testPlans;
    }

    public void setTestPlans(List<ExProgressTestPlanDto> testPlans) {
        this.testPlans = testPlans;
    }

    public void addTestPlanDto(ExProgressTestPlanDto testPlanDto) {
        this.testPlans.add(testPlanDto);
    }

    public ExProgressIterationDto fillBasicInfos(Iteration iteration) {
        this.name = iteration.getName();
        this.scheduledStartDate = iteration.getScheduledStartDate();
        this.scheduledEndDate = iteration.getScheduledEndDate();
        this.actualStartDate = iteration.getActualStartDate();
        this.actualEndDate = iteration.getActualEndDate();
        return this;
    }

    public List<ExProgressTestSuiteDto> getTestSuites() {
        return this.testSuites;
    }

    public void setTestSuites(List<ExProgressTestSuiteDto> testSuites) {
        this.testSuites = testSuites;
    }
}

