/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.internal.domain.report.common.dto;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.internal.domain.report.common.dto.ExProgressCampaignDto;
import org.squashtest.tm.internal.domain.report.common.dto.ExProgressScheduledAbstractDto;
import org.squashtest.tm.internal.domain.report.common.dto.ExProgressTestPlanDto;
import org.squashtest.tm.internal.domain.report.common.dto.ExProgressTestSuiteDto;

public class ExProgressIterationDto
extends ExProgressScheduledAbstractDto {
    private ExProgressCampaignDto campaign;
    private List<ExProgressTestPlanDto> testPlans = new LinkedList<ExProgressTestPlanDto>();
    private List<ExProgressTestSuiteDto> testSuites = new LinkedList<ExProgressTestSuiteDto>();

    public ExProgressIterationDto(Iteration iteration) {
        super(iteration.getTestPlans());
        this.fillBasicInfos(iteration);
        this.fillTestSuiteInfos(iteration);
    }

    private ExProgressIterationDto fillBasicInfos(Iteration iteration) {
        this.name = iteration.getName();
        this.scheduledStartDate = iteration.getScheduledStartDate();
        this.scheduledEndDate = iteration.getScheduledEndDate();
        this.actualStartDate = iteration.getActualStartDate();
        this.actualEndDate = iteration.getActualEndDate();
        return this;
    }

    public ExProgressCampaignDto getCampaign() {
        return this.campaign;
    }

    public void setCampaign(ExProgressCampaignDto campaign) {
        this.campaign = campaign;
    }

    private void fillTestSuiteInfos(Iteration iteration) {
        for (TestSuite testSuite : iteration.getTestSuites()) {
            ExProgressTestSuiteDto testSuiteDto = new ExProgressTestSuiteDto(testSuite);
            testSuiteDto.setIteration(this);
            this.testSuites.add(testSuiteDto);
            Collections.sort(this.testSuites, new testSuiteComparator());
        }
    }

    public List<ExProgressTestPlanDto> getTestPlans() {
        return this.testPlans;
    }

    public void setTestPlans(List<ExProgressTestPlanDto> testPlans) {
        this.testPlans = testPlans;
    }

    public void addTestPlanDto(ExProgressTestPlanDto testPlanDto) {
        this.testPlans.add(testPlanDto);
    }

    public List<ExProgressTestSuiteDto> getTestSuites() {
        return this.testSuites;
    }

    public void setTestSuites(List<ExProgressTestSuiteDto> testSuites) {
        this.testSuites = testSuites;
    }

    public boolean isAllowsSettled() {
        return this.getCampaign().getProject().isAllowsSettled();
    }

    public boolean isAllowsUntestable() {
        return this.getCampaign().getProject().isAllowsUntestable();
    }

    private static class testSuiteComparator
    implements Comparator<ExProgressTestSuiteDto> {
        private testSuiteComparator() {
        }

        @Override
        public int compare(ExProgressTestSuiteDto suite1, ExProgressTestSuiteDto suite2) {
            return suite1.getName().compareTo(suite2.getName());
        }
    }
}

